/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.ByteBuffers;

public class EncryptingWritableByteChannel
implements WritableByteChannel {
    private final WritableByteChannel delegate;
    private final Cryptor cryptor;
    private final FileHeader header;
    private final ByteBuffer cleartextBuffer;
    long written = 0L;
    long chunkNumber = 0L;

    public EncryptingWritableByteChannel(WritableByteChannel destination, Cryptor cryptor) {
        this.delegate = destination;
        this.cryptor = cryptor;
        this.header = cryptor.fileHeaderCryptor().create();
        this.cleartextBuffer = ByteBuffer.allocate(cryptor.fileContentCryptor().cleartextChunkSize());
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.encryptAndflushBuffer();
        this.delegate.close();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.written == 0L) {
            this.delegate.write(this.cryptor.fileHeaderCryptor().encryptHeader(this.header));
        }
        int result = 0;
        while (src.hasRemaining()) {
            result += ByteBuffers.copy(src, this.cleartextBuffer);
            if (this.cleartextBuffer.hasRemaining()) continue;
            this.encryptAndflushBuffer();
        }
        this.written += (long)result;
        return result;
    }

    private void encryptAndflushBuffer() throws IOException {
        this.cleartextBuffer.flip();
        if (this.cleartextBuffer.hasRemaining()) {
            ByteBuffer ciphertextBuffer = this.cryptor.fileContentCryptor().encryptChunk(this.cleartextBuffer, this.chunkNumber++, this.header);
            this.delegate.write(ciphertextBuffer);
        }
        this.cleartextBuffer.clear();
    }
}

