/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.Metadata;

public class DropboxAttributesFinderFeature
implements AttributesFinder {
    private final DropboxSession session;

    public DropboxAttributesFinderFeature(DropboxSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        try {
            Metadata metadata = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).getMetadata(file.getAbsolute());
            return this.convert(metadata);
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    protected PathAttributes convert(Metadata metadata) {
        PathAttributes attributes = new PathAttributes();
        if (metadata instanceof FileMetadata) {
            FileMetadata fm = (FileMetadata)metadata;
            attributes.setSize(fm.getSize());
            attributes.setVersionId(fm.getId());
            attributes.setModificationDate(fm.getClientModified().getTime());
        } else if (metadata instanceof FolderMetadata) {
            FolderMetadata fm = (FolderMetadata)metadata;
            attributes.setVersionId(fm.getId());
        }
        return attributes;
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        return this;
    }
}

