/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.http.DelayedHttpEntity;
import ch.cyberduck.core.threading.DefaultThreadPool;
import com.dropbox.core.http.HttpRequestor;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;

public class DropboxCommonsHttpRequestExecutor
extends HttpRequestor
implements Closeable {
    private static final Logger log = Logger.getLogger(DropboxCommonsHttpRequestExecutor.class);
    private final CloseableHttpClient client;

    public DropboxCommonsHttpRequestExecutor(CloseableHttpClient client) {
        this.client = client;
    }

    public HttpRequestor.Response doGet(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpGet request = new HttpGet(url);
        for (HttpRequestor.Header header : headers) {
            if (header.getKey().equals("Transfer-Encoding") || header.getKey().equals("Content-Length")) continue;
            request.addHeader((Header)new BasicHeader(header.getKey(), header.getValue()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Header header : response.getAllHeaders()) {
            responseHeaders.put(header.getName(), Collections.singletonList(header.getValue()));
        }
        return new HttpRequestor.Response(response.getStatusLine().getStatusCode(), response.getEntity().getContent(), responseHeaders);
    }

    public HttpRequestor.Uploader startPost(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpPost request = new HttpPost(url);
        return this.execute(url, headers, (HttpEntityEnclosingRequestBase)request);
    }

    public HttpRequestor.Uploader startPut(String url, Iterable<HttpRequestor.Header> headers) throws IOException {
        HttpPut request = new HttpPut(url);
        return this.execute(url, headers, (HttpEntityEnclosingRequestBase)request);
    }

    private HttpRequestor.Uploader execute(final String url, final Iterable<HttpRequestor.Header> headers, final HttpEntityEnclosingRequestBase request) throws IOException {
        for (HttpRequestor.Header header : headers) {
            if (header.getKey().equals("Transfer-Encoding") || header.getKey().equals("Content-Length")) continue;
            request.addHeader((Header)new BasicHeader(header.getKey(), header.getValue()));
        }
        final CountDownLatch entry = new CountDownLatch(1);
        final DelayedHttpEntity entity = new DelayedHttpEntity(entry){

            public long getContentLength() {
                for (HttpRequestor.Header header : headers) {
                    if (!header.getKey().equals("Content-Length")) continue;
                    return Long.valueOf(header.getValue());
                }
                return -1L;
            }
        };
        request.setEntity((HttpEntity)entity);
        final DefaultThreadPool executor = new DefaultThreadPool(String.format("http-%s", url), 1);
        final Future future = executor.execute((Callable)new Callable<CloseableHttpResponse>(){

            @Override
            public CloseableHttpResponse call() throws Exception {
                return DropboxCommonsHttpRequestExecutor.this.client.execute((HttpUriRequest)request);
            }
        });
        return new HttpRequestor.Uploader(){

            public OutputStream getBody() {
                try {
                    entry.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return entity.getStream();
            }

            public void close() {
                try {
                    entity.getStream().close();
                }
                catch (IOException e) {
                    log.warn((Object)String.format("Failure closing stream for %s. %s", url, e.getMessage()));
                }
            }

            public void abort() {
                this.close();
            }

            public HttpRequestor.Response finish() throws IOException {
                CloseableHttpResponse response;
                try {
                    response = (CloseableHttpResponse)future.get();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                catch (ExecutionException e) {
                    throw new IOException(e.getCause());
                }
                finally {
                    executor.shutdown(false);
                }
                HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                for (Header header : response.getAllHeaders()) {
                    responseHeaders.put(header.getName(), Collections.singletonList(header.getValue()));
                }
                return new HttpRequestor.Response(response.getStatusLine().getStatusCode(), response.getEntity().getContent(), responseHeaders);
            }
        };
    }

    public HttpClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

