/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.IdProvider;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class DropboxFileIdProvider
implements IdProvider {
    private final DropboxSession session;
    private Cache<Path> cache = PathCache.empty();

    public DropboxFileIdProvider(DropboxSession session) {
        this.session = session;
    }

    public String getFileid(Path file) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            return file.attributes().getVersionId();
        }
        if (file.isRoot()) {
            return null;
        }
        if (this.cache.isCached((Referenceable)file.getParent())) {
            AttributedList list = this.cache.get((Referenceable)file.getParent());
            Path found = (Path)list.find((Predicate)new SimplePathPredicate(file));
            if (null == found) {
                throw new NotfoundException(file.getAbsolute());
            }
            return found.attributes().getVersionId();
        }
        return new DropboxAttributesFinderFeature(this.session).withCache(this.cache).find(file).getVersionId();
    }

    public IdProvider withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

