/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import java.util.EnumSet;
import org.apache.log4j.Logger;

public class DropboxListService
implements ListService {
    private static final Logger log = Logger.getLogger(DropboxListService.class);
    private final DropboxSession session;
    private final DropboxAttributesFinderFeature attributes;

    public DropboxListService(DropboxSession session) {
        this.session = session;
        this.attributes = new DropboxAttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList children = new AttributedList();
            String path = directory.isRoot() ? "" : directory.getAbsolute();
            ListFolderResult result = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).listFolder(path);
            this.parse(directory, listener, (AttributedList<Path>)children, result);
            while (result.getHasMore()) {
                result = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).listFolderContinue(result.getCursor());
                this.parse(directory, listener, (AttributedList<Path>)children, result);
            }
            return children;
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map(e);
        }
    }

    private void parse(Path directory, ListProgressListener listener, AttributedList<Path> children, ListFolderResult result) throws ConnectionCanceledException {
        for (Metadata md : result.getEntries()) {
            Path child = this.parse(directory, md);
            if (child == null) continue;
            children.add((Referenceable)child);
            listener.chunk(directory, children);
        }
    }

    protected Path parse(Path directory, Metadata metadata) {
        EnumSet<AbstractPath.Type> type;
        if (metadata instanceof FileMetadata) {
            type = EnumSet.of(AbstractPath.Type.file);
        } else if (metadata instanceof FolderMetadata) {
            type = EnumSet.of(AbstractPath.Type.directory);
        } else {
            log.warn((Object)String.format("Skip file %s", metadata));
            return null;
        }
        return new Path(directory, PathNormalizer.name((String)metadata.getName()), type, this.attributes.convert(metadata));
    }
}

