/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;

public class DropboxMoveFeature
implements Move {
    private final DropboxSession session;

    public DropboxMoveFeature(DropboxSession session) {
        this.session = session;
    }

    public void move(Path file, Path renamed, boolean exists, Delete.Callback callback) throws BackgroundException {
        try {
            new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).move(file.getAbsolute(), renamed.getAbsolute());
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Cannot move {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }

    public Move withDelete(Delete delete) {
        return this;
    }
}

