/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import java.io.IOException;
import java.io.InputStream;

public class DropboxReadFeature
implements Read {
    private final DropboxSession session;

    public DropboxReadFeature(DropboxSession session) {
        this.session = session;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            DbxDownloader downloader = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).download(file.getAbsolute());
            InputStream in = downloader.getInputStream();
            if (status.isAppend()) {
                in.skip(status.getOffset());
            }
            return in;
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }

    public boolean offset(Path file) throws BackgroundException {
        return false;
    }
}

