/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UseragentProvider;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxCommonsHttpRequestExecutor;
import ch.cyberduck.core.dropbox.DropboxCopyFeature;
import ch.cyberduck.core.dropbox.DropboxDeleteFeature;
import ch.cyberduck.core.dropbox.DropboxDirectoryFeature;
import ch.cyberduck.core.dropbox.DropboxFileIdProvider;
import ch.cyberduck.core.dropbox.DropboxFindFeature;
import ch.cyberduck.core.dropbox.DropboxListService;
import ch.cyberduck.core.dropbox.DropboxMoveFeature;
import ch.cyberduck.core.dropbox.DropboxQuotaFeature;
import ch.cyberduck.core.dropbox.DropboxReadFeature;
import ch.cyberduck.core.dropbox.DropboxSearchFeature;
import ch.cyberduck.core.dropbox.DropboxTouchFeature;
import ch.cyberduck.core.dropbox.DropboxUploadFeature;
import ch.cyberduck.core.dropbox.DropboxUrlProvider;
import ch.cyberduck.core.dropbox.DropboxWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.v2.DbxRawClientV2;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class DropboxSession
extends HttpSession<DbxRawClientV2> {
    private final Preferences preferences = PreferencesFactory.get();
    private final UseragentProvider useragent = new PreferencesUseragentProvider();
    private final OAuth2RequestInterceptor authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build((TranscriptListener)this).build(), "https://api.dropboxapi.com/1/oauth2/token", "https://www.dropbox.com/1/oauth2/authorize", this.host.getProtocol().getClientId(), this.host.getProtocol().getClientSecret(), Collections.emptyList()).withRedirectUri(this.preferences.getProperty("dropbox.oauth.redirecturi"));
    private final OAuth2ErrorResponseInterceptor retryHandler = new OAuth2ErrorResponseInterceptor(this.authorizationService);

    public DropboxSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    protected DbxRawClientV2 connect(HostKeyCallback callback) throws BackgroundException {
        HttpClientBuilder configuration = this.builder.build((TranscriptListener)this);
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)this.retryHandler);
        CloseableHttpClient client = configuration.build();
        return new DbxRawClientV2(DbxRequestConfig.newBuilder((String)this.useragent.get()).withAutoRetryDisabled().withHttpRequestor((HttpRequestor)new DropboxCommonsHttpRequestExecutor(client)).build(), DbxHost.DEFAULT){

            protected void addAuthHeaders(List<HttpRequestor.Header> headers) {
            }
        };
    }

    public void login(HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel, Cache<Path> cache) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, keychain, prompt, cancel));
    }

    protected void logout() throws BackgroundException {
        try {
            ((DropboxCommonsHttpRequestExecutor)((DbxRawClientV2)this.client).getRequestConfig().getHttpRequestor()).close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return new DropboxListService(this).list(directory, listener);
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Read.class) {
            return (T)new DropboxReadFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new DropboxWriteFeature(this));
        }
        if (type == Upload.class) {
            return (T)((Object)new DropboxUploadFeature(new DropboxWriteFeature(this)));
        }
        if (type == Directory.class) {
            return (T)new DropboxDirectoryFeature(this);
        }
        if (type == Delete.class) {
            return (T)new DropboxDeleteFeature(this);
        }
        if (type == Move.class) {
            return (T)new DropboxMoveFeature(this);
        }
        if (type == Copy.class) {
            return (T)new DropboxCopyFeature(this);
        }
        if (type == UrlProvider.class) {
            return (T)new DropboxUrlProvider(this);
        }
        if (type == IdProvider.class) {
            return (T)new DropboxFileIdProvider(this);
        }
        if (type == Find.class) {
            return (T)new DropboxFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new DropboxAttributesFinderFeature(this);
        }
        if (type == Quota.class) {
            return (T)new DropboxQuotaFeature(this);
        }
        if (type == Touch.class) {
            return (T)((Object)new DropboxTouchFeature(this));
        }
        if (type == Search.class) {
            return (T)new DropboxSearchFeature(this);
        }
        return (T)super._getFeature(type);
    }
}

