/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.UploadSessionAppendV2Uploader;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.dropbox.core.v2.files.UploadSessionFinishUploader;
import com.dropbox.core.v2.files.UploadSessionStartResult;
import com.dropbox.core.v2.files.UploadSessionStartUploader;
import com.dropbox.core.v2.files.WriteMode;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;

public class DropboxWriteFeature
extends AbstractHttpWriteFeature<String> {
    private static final Logger log = Logger.getLogger(DropboxWriteFeature.class);
    private static final long DEFAULT_CHUNK_SIZE = 150000000L;
    private final DropboxSession session;
    private final Find finder;
    private final AttributesFinder attributes;
    private final Long chunksize;

    public DropboxWriteFeature(DropboxSession session) {
        this(session, 150000000L);
    }

    public DropboxWriteFeature(DropboxSession session, Long chunksize) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session), chunksize);
    }

    public DropboxWriteFeature(DropboxSession session, Find finder, AttributesFinder attributes, Long chunksize) {
        super(finder, attributes);
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
        this.chunksize = chunksize;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attributes = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }

    public HttpResponseOutputStream<String> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            DbxUserFilesRequests files = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient());
            UploadSessionStartUploader start = files.uploadSessionStart();
            new DefaultStreamCloser().close(start.getOutputStream());
            String sessionId = ((UploadSessionStartResult)start.finish()).getSessionId();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Obtained session id %s for upload %s", sessionId, file));
            }
            UploadSessionAppendV2Uploader uploader = this.open(files, sessionId, 0L);
            return new SegmentingUploadProxyOutputStream(file, status, files, uploader, sessionId);
        }
        catch (DbxException ex) {
            throw new DropboxExceptionMappingService().map("Upload failed.", ex, file);
        }
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    private UploadSessionAppendV2Uploader open(DbxUserFilesRequests files, String sessionId, Long offset) throws DbxException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Open next segment for upload session %s", sessionId));
        }
        return files.uploadSessionAppendV2(new UploadSessionCursor(sessionId, offset.longValue()));
    }

    private void close(UploadSessionAppendV2Uploader uploader) throws DbxException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Close uploader %s", uploader));
        }
        uploader.getOutputStream().close();
        uploader.finish();
    }

    public ChecksumCompute checksum() {
        return new DisabledChecksumCompute();
    }

    private final class SegmentingUploadProxyOutputStream
    extends HttpResponseOutputStream<String> {
        private final Path file;
        private final TransferStatus status;
        private final DbxUserFilesRequests client;
        private final String sessionId;
        private String fileId;
        private Long offset;
        private Long written;
        private UploadSessionAppendV2Uploader uploader;

        public SegmentingUploadProxyOutputStream(Path file, TransferStatus status, DbxUserFilesRequests client, UploadSessionAppendV2Uploader uploader, String sessionId) throws DbxException {
            super(uploader.getOutputStream());
            this.offset = 0L;
            this.written = 0L;
            this.file = file;
            this.status = status;
            this.client = client;
            this.uploader = uploader;
            this.sessionId = sessionId;
        }

        protected void beforeWrite(int n) throws IOException {
            if (this.offset + (long)n > DropboxWriteFeature.this.chunksize) {
                try {
                    DropboxWriteFeature.this.close(this.uploader);
                    this.next();
                }
                catch (DbxException e) {
                    throw new IOException((Throwable)new DropboxExceptionMappingService().map(e));
                }
            }
        }

        private void next() throws DbxException {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Open next segment for upload session %s for file %s", this.sessionId, this.file));
            }
            this.uploader = DropboxWriteFeature.this.open(this.client, this.sessionId, this.written);
            this.out = this.uploader.getOutputStream();
            this.offset = 0L;
        }

        protected void afterWrite(int n) throws IOException {
            this.offset = this.offset + (long)n;
            this.written = this.written + (long)n;
        }

        public String getStatus() throws BackgroundException {
            return this.fileId;
        }

        public void close() throws IOException {
            try {
                DropboxWriteFeature.this.close(this.uploader);
                UploadSessionFinishUploader finish = this.client.uploadSessionFinish(new UploadSessionCursor(this.sessionId, this.written.longValue()), CommitInfo.newBuilder((String)this.file.getAbsolute()).withClientModified(this.status.getTimestamp() != null ? new Date(this.status.getTimestamp()) : null).withMode(WriteMode.OVERWRITE).build());
                finish.getOutputStream().close();
                FileMetadata metadtata = (FileMetadata)finish.finish();
                this.fileId = metadtata.getId();
            }
            catch (IllegalStateException finish) {
            }
            catch (DbxException e) {
                throw new IOException("Upload failed.", (Throwable)new DropboxExceptionMappingService().map(e));
            }
            finally {
                super.close();
            }
        }
    }
}

