/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AclUpdatePolicy;
import com.dropbox.core.v2.sharing.MemberPolicy;
import com.dropbox.core.v2.sharing.SharedLinkPolicy;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class ShareFolderArg {
    protected final String path;
    protected final MemberPolicy memberPolicy;
    protected final AclUpdatePolicy aclUpdatePolicy;
    protected final SharedLinkPolicy sharedLinkPolicy;
    protected final boolean forceAsync;

    public ShareFolderArg(String path, MemberPolicy memberPolicy, AclUpdatePolicy aclUpdatePolicy, SharedLinkPolicy sharedLinkPolicy, boolean forceAsync) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (memberPolicy == null) {
            throw new IllegalArgumentException("Required value for 'memberPolicy' is null");
        }
        this.memberPolicy = memberPolicy;
        if (aclUpdatePolicy == null) {
            throw new IllegalArgumentException("Required value for 'aclUpdatePolicy' is null");
        }
        this.aclUpdatePolicy = aclUpdatePolicy;
        if (sharedLinkPolicy == null) {
            throw new IllegalArgumentException("Required value for 'sharedLinkPolicy' is null");
        }
        this.sharedLinkPolicy = sharedLinkPolicy;
        this.forceAsync = forceAsync;
    }

    public ShareFolderArg(String path) {
        this(path, MemberPolicy.ANYONE, AclUpdatePolicy.OWNER, SharedLinkPolicy.ANYONE, false);
    }

    public String getPath() {
        return this.path;
    }

    public MemberPolicy getMemberPolicy() {
        return this.memberPolicy;
    }

    public AclUpdatePolicy getAclUpdatePolicy() {
        return this.aclUpdatePolicy;
    }

    public SharedLinkPolicy getSharedLinkPolicy() {
        return this.sharedLinkPolicy;
    }

    public boolean getForceAsync() {
        return this.forceAsync;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.memberPolicy, this.aclUpdatePolicy, this.sharedLinkPolicy, this.forceAsync});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ShareFolderArg other = (ShareFolderArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.memberPolicy != other.memberPolicy && !this.memberPolicy.equals((Object)other.memberPolicy) || this.aclUpdatePolicy != other.aclUpdatePolicy && !this.aclUpdatePolicy.equals((Object)other.aclUpdatePolicy) || this.sharedLinkPolicy != other.sharedLinkPolicy && !this.sharedLinkPolicy.equals((Object)other.sharedLinkPolicy) || this.forceAsync != other.forceAsync);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ShareFolderArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ShareFolderArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("member_policy");
            MemberPolicy.Serializer.INSTANCE.serialize(value.memberPolicy, g);
            g.writeFieldName("acl_update_policy");
            AclUpdatePolicy.Serializer.INSTANCE.serialize(value.aclUpdatePolicy, g);
            g.writeFieldName("shared_link_policy");
            SharedLinkPolicy.Serializer.INSTANCE.serialize(value.sharedLinkPolicy, g);
            g.writeFieldName("force_async");
            StoneSerializers.boolean_().serialize((Boolean)value.forceAsync, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ShareFolderArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_forceAsync;
            SharedLinkPolicy f_sharedLinkPolicy;
            AclUpdatePolicy f_aclUpdatePolicy;
            MemberPolicy f_memberPolicy;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_memberPolicy = MemberPolicy.ANYONE;
                f_aclUpdatePolicy = AclUpdatePolicy.OWNER;
                f_sharedLinkPolicy = SharedLinkPolicy.ANYONE;
                f_forceAsync = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("member_policy".equals(field)) {
                        f_memberPolicy = MemberPolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("acl_update_policy".equals(field)) {
                        f_aclUpdatePolicy = AclUpdatePolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("shared_link_policy".equals(field)) {
                        f_sharedLinkPolicy = SharedLinkPolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("force_async".equals(field)) {
                        f_forceAsync = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ShareFolderArg value = new ShareFolderArg(f_path, f_memberPolicy, f_aclUpdatePolicy, f_sharedLinkPolicy, f_forceAsync);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String path;
        protected MemberPolicy memberPolicy;
        protected AclUpdatePolicy aclUpdatePolicy;
        protected SharedLinkPolicy sharedLinkPolicy;
        protected boolean forceAsync;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            this.memberPolicy = MemberPolicy.ANYONE;
            this.aclUpdatePolicy = AclUpdatePolicy.OWNER;
            this.sharedLinkPolicy = SharedLinkPolicy.ANYONE;
            this.forceAsync = false;
        }

        public Builder withMemberPolicy(MemberPolicy memberPolicy) {
            this.memberPolicy = memberPolicy != null ? memberPolicy : MemberPolicy.ANYONE;
            return this;
        }

        public Builder withAclUpdatePolicy(AclUpdatePolicy aclUpdatePolicy) {
            this.aclUpdatePolicy = aclUpdatePolicy != null ? aclUpdatePolicy : AclUpdatePolicy.OWNER;
            return this;
        }

        public Builder withSharedLinkPolicy(SharedLinkPolicy sharedLinkPolicy) {
            this.sharedLinkPolicy = sharedLinkPolicy != null ? sharedLinkPolicy : SharedLinkPolicy.ANYONE;
            return this;
        }

        public Builder withForceAsync(Boolean forceAsync) {
            this.forceAsync = forceAsync != null ? forceAsync : false;
            return this;
        }

        public ShareFolderArg build() {
            return new ShareFolderArg(this.path, this.memberPolicy, this.aclUpdatePolicy, this.sharedLinkPolicy, this.forceAsync);
        }
    }
}

