/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client;

import com.google.common.base.Joiner;
import com.google.common.collect.Multimap;
import com.google.common.net.UrlEscapers;
import com.spectralogic.ds3client.Ds3InputStreamEntity;
import com.spectralogic.ds3client.HashGeneratingMatchHandler;
import com.spectralogic.ds3client.commands.Ds3Request;
import com.spectralogic.ds3client.models.Checksum;
import com.spectralogic.ds3client.models.SignatureDetails;
import com.spectralogic.ds3client.networking.ConnectionDetails;
import com.spectralogic.ds3client.networking.NetUtils;
import com.spectralogic.ds3client.networking.NetworkClient;
import com.spectralogic.ds3client.networking.RequiresMarkSupportedException;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.utils.DateFormatter;
import com.spectralogic.ds3client.utils.SSLSetupException;
import com.spectralogic.ds3client.utils.Signature;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkClientImpl
implements NetworkClient {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkClientImpl.class);
    private static final String HOST = "HOST";
    private static final String DATE = "DATE";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_MD5 = "Content-MD5";
    private static final String CONTENT_SHA256 = "Content-SHA256";
    private static final String CONTENT_SHA512 = "Content-SHA512";
    private static final String CONTENT_CRC32 = "Content-CRC32";
    private static final String CONTENT_CRC32C = "Content-CRC32C";
    private static final int MAX_CONNECTION_PER_ROUTE = 50;
    private static final int MAX_CONNECTION_TOTAL = 100;
    private final ConnectionDetails connectionDetails;
    private final CloseableHttpClient client;
    private final HttpHost host;

    public NetworkClientImpl(ConnectionDetails connectionDetails) {
        if (connectionDetails == null) {
            throw new AssertionError((Object)"ConnectionDetails cannot be null");
        }
        try {
            this.connectionDetails = connectionDetails;
            this.host = NetworkClientImpl.buildHost(connectionDetails);
            this.client = NetworkClientImpl.createDefaultClient(connectionDetails);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public NetworkClientImpl(ConnectionDetails connectionDetails, CloseableHttpClient client) {
        if (connectionDetails == null) {
            throw new AssertionError((Object)"ConnectionDetails cannot be null");
        }
        if (client == null) {
            throw new AssertionError((Object)"CloseableHttpClient cannot be null");
        }
        try {
            this.connectionDetails = connectionDetails;
            this.host = NetworkClientImpl.buildHost(connectionDetails);
            this.client = client;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static CloseableHttpClient createDefaultClient(ConnectionDetails connectionDetails) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(50);
        connectionManager.setMaxTotal(100);
        if (connectionDetails.isHttps() && !connectionDetails.isCertificateVerification()) {
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).useTLS().build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new AllowAllHostnameVerifier());
                return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new SSLSetupException(e);
            }
        }
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    private static HttpHost buildHost(ConnectionDetails connectionDetails) throws MalformedURLException {
        URI proxyUri = connectionDetails.getProxy();
        if (proxyUri != null) {
            return new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme());
        }
        URL url = NetUtils.buildUrl(connectionDetails, "/");
        return new HttpHost(url.getHost(), NetUtils.getPort(url), url.getProtocol());
    }

    @Override
    public ConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    /*
     * Exception decompiling
     */
    @Override
    public WebResponse getResponse(Ds3Request request) throws IOException, SignatureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private class RequestExecutor
    implements Closeable {
        private final Ds3Request ds3Request;
        private final InputStream content;
        private final HttpHost host;
        private final String hash;
        private final Checksum.Type checksumType;
        private final CloseableHttpClient client;

        public RequestExecutor(CloseableHttpClient client, HttpHost host, Ds3Request ds3Request) throws IOException {
            this.client = client;
            this.ds3Request = ds3Request;
            this.host = host;
            this.content = ds3Request.getStream();
            if (this.content != null && !this.content.markSupported()) {
                throw new RequiresMarkSupportedException();
            }
            LOG.info("Sending request: " + (Object)((Object)this.ds3Request.getVerb()) + " " + this.host.toString() + "" + this.ds3Request.getPath());
            this.checksumType = ds3Request.getChecksumType();
            this.hash = this.buildHash();
        }

        public CloseableHttpResponse execute() throws IOException, SignatureException {
            if (this.content != null) {
                this.content.reset();
            }
            HttpRequest httpRequest = this.buildHttpRequest();
            this.addHeaders(httpRequest);
            return this.client.execute(this.host, httpRequest, (HttpContext)this.getContext());
        }

        private HttpRequest buildHttpRequest() throws IOException {
            String verb = this.ds3Request.getVerb().toString();
            String path = this.buildPath();
            if (this.content != null) {
                BasicHttpEntityEnclosingRequest httpRequest = new BasicHttpEntityEnclosingRequest(verb, path);
                Ds3InputStreamEntity entityStream = new Ds3InputStreamEntity(this.content, this.ds3Request.getSize(), ContentType.create((String)this.ds3Request.getContentType()), this.ds3Request.getPath());
                entityStream.setBufferSize(NetworkClientImpl.this.connectionDetails.getBufferSize());
                httpRequest.setEntity((HttpEntity)entityStream);
                return httpRequest;
            }
            return new BasicHttpRequest(verb, path);
        }

        private String buildPath() {
            String path = UrlEscapers.urlFragmentEscaper().escape(this.ds3Request.getPath());
            Map<String, String> queryParams = this.ds3Request.getQueryParams();
            if (!queryParams.isEmpty()) {
                path = path + "?" + NetUtils.buildQueryString(queryParams);
            }
            return path;
        }

        private void addHeaders(HttpRequest httpRequest) throws IOException, SignatureException {
            String date = DateFormatter.dateToRfc882();
            httpRequest.addHeader(NetworkClientImpl.HOST, NetUtils.buildHostField(NetworkClientImpl.this.connectionDetails));
            httpRequest.addHeader(NetworkClientImpl.DATE, date);
            httpRequest.addHeader(NetworkClientImpl.CONTENT_TYPE, this.ds3Request.getContentType());
            for (Map.Entry header : this.ds3Request.getHeaders().entries()) {
                httpRequest.addHeader((String)header.getKey(), (String)header.getValue());
            }
            if (!this.hash.isEmpty()) {
                httpRequest.addHeader(this.getHashType(this.ds3Request.getChecksumType()), this.hash);
            }
            httpRequest.addHeader(NetworkClientImpl.AUTHORIZATION, this.getSignature(new SignatureDetails(this.ds3Request.getVerb(), this.hash, this.ds3Request.getContentType(), date, this.canonicalizeAmzHeaders(this.ds3Request.getHeaders()), this.canonicalizeResource(this.ds3Request.getPath(), this.ds3Request.getQueryParams()), NetworkClientImpl.this.connectionDetails.getCredentials())));
        }

        private String getHashType(Checksum.Type checksumType) {
            switch (checksumType) {
                case MD5: {
                    return NetworkClientImpl.CONTENT_MD5;
                }
                case SHA256: {
                    return NetworkClientImpl.CONTENT_SHA256;
                }
                case SHA512: {
                    return NetworkClientImpl.CONTENT_SHA512;
                }
                case CRC32: {
                    return NetworkClientImpl.CONTENT_CRC32;
                }
                case CRC32C: {
                    return NetworkClientImpl.CONTENT_CRC32C;
                }
            }
            return "";
        }

        private String canonicalizeResource(String path, Map<String, String> queryParams) {
            StringBuilder canonicalizedResource = new StringBuilder();
            canonicalizedResource.append(UrlEscapers.urlFragmentEscaper().escape(path));
            if (queryParams.containsKey("delete")) {
                canonicalizedResource.append("?delete");
            }
            return canonicalizedResource.toString();
        }

        private String canonicalizeAmzHeaders(Multimap<String, String> customHeaders) {
            StringBuilder ret = new StringBuilder();
            for (Map.Entry header : customHeaders.asMap().entrySet()) {
                String key = ((String)header.getKey()).toLowerCase();
                if (!key.startsWith("x-amz-meta-") || ((Collection)header.getValue()).size() <= 0) continue;
                ret.append(key).append(":");
                ret.append(Joiner.on((String)",").join((Iterable)header.getValue()));
                ret.append('\n');
            }
            return ret.toString();
        }

        private String buildHash() throws IOException {
            return this.ds3Request.getChecksum().match(new HashGeneratingMatchHandler(this.content, this.checksumType));
        }

        private String getSignature(SignatureDetails details) throws SignatureException {
            return "AWS " + NetworkClientImpl.this.connectionDetails.getCredentials().getClientId() + ':' + Signature.signature(details);
        }

        private HttpClientContext getContext() {
            HttpClientContext context = new HttpClientContext();
            context.setRequestConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
            return context;
        }

        @Override
        public void close() throws IOException {
            if (this.content != null) {
                this.content.close();
            }
        }
    }
}

