/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.spectralogic.ds3client.commands.Ds3Request;
import com.spectralogic.ds3client.models.Checksum;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public abstract class AbstractRequest
implements Ds3Request {
    private final Multimap<String, String> headers = AbstractRequest.buildDefaultHeaders();
    private final Map<String, String> queryParams = new HashMap<String, String>();

    private static Multimap<String, String> buildDefaultHeaders() {
        TreeMultimap headers = TreeMultimap.create();
        headers.put((Object)"Naming-Convention", (Object)"s3");
        return headers;
    }

    @Override
    public String getContentType() {
        return ContentType.APPLICATION_XML.getMimeType();
    }

    @Override
    public InputStream getStream() {
        return null;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public Checksum getChecksum() {
        return Checksum.none();
    }

    @Override
    public Checksum.Type getChecksumType() {
        return Checksum.Type.NONE;
    }

    @Override
    public final Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public final Multimap<String, String> getHeaders() {
        return this.headers;
    }

    final void updateQueryParam(String name, String param) {
        if (param == null) {
            this.queryParams.remove(name);
        } else {
            this.queryParams.put(name, param);
        }
    }
}

