/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.google.common.net.UrlEscapers;
import com.spectralogic.ds3client.HttpVerb;
import com.spectralogic.ds3client.commands.AbstractRequest;

public class GetBucketRequest
extends AbstractRequest {
    private final String bucket;
    private String nextMarker = null;
    private String prefix = null;
    private String delimiter = null;
    private int maxKeys = 0;

    public GetBucketRequest(String bucket) {
        this.bucket = bucket;
    }

    public GetBucketRequest withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        this.getQueryParams().put("marker", UrlEscapers.urlFragmentEscaper().escape(nextMarker));
        return this;
    }

    public GetBucketRequest withPrefix(String prefix) {
        this.prefix = prefix;
        this.getQueryParams().put("prefix", UrlEscapers.urlFragmentEscaper().escape(prefix));
        return this;
    }

    public GetBucketRequest withMaxKeys(int maxKeys) {
        this.maxKeys = maxKeys;
        this.getQueryParams().put("max-keys", Integer.toString(maxKeys));
        return this;
    }

    public GetBucketRequest withDelimiter(String delimiter) {
        this.delimiter = delimiter;
        this.getQueryParams().put("delimiter", delimiter);
        return this;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public String getPath() {
        return "/" + this.bucket;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    public String getDelimiter() {
        return this.delimiter;
    }
}

