/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.AbstractResponse;
import com.spectralogic.ds3client.models.ListBucketResult;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBucketResponse
extends AbstractResponse {
    private static final Logger LOG = LoggerFactory.getLogger(GetBucketResponse.class);
    private ListBucketResult result;

    public GetBucketResponse(WebResponse response) throws IOException {
        super(response);
    }

    public ListBucketResult getResult() {
        return this.result;
    }

    @Override
    protected void processResponse() throws IOException {
        try (WebResponse response = this.getResponse();
             InputStream contentStream = response.getResponseStream();){
            this.checkStatusCode(200);
            LOG.debug("Starting bucket xml parsing");
            this.result = XmlOutput.fromXml(contentStream, ListBucketResult.class);
            LOG.debug("Finished bucket xml parsing");
        }
    }
}

