/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.HttpVerb;
import com.spectralogic.ds3client.commands.AbstractRequest;
import java.util.UUID;

public class GetObjectsRequest
extends AbstractRequest {
    private String bucketName;
    private String objectName;
    private int pageLength;
    private int pageOffset;
    private long version;
    private UUID objectId;
    private ObjectType objectType;

    public GetObjectsRequest withBucket(String bucketName) {
        this.bucketName = bucketName;
        this.getQueryParams().put("bucket_id", this.bucketName);
        return this;
    }

    public GetObjectsRequest withObjectId(UUID objectId) {
        this.objectId = objectId;
        this.getQueryParams().put("id", objectId.toString());
        return this;
    }

    public GetObjectsRequest withObjectName(String objectName) {
        this.objectName = objectName;
        this.getQueryParams().put("name", objectName);
        return this;
    }

    public GetObjectsRequest withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.getQueryParams().put("page_length", Integer.toString(pageLength));
        return this;
    }

    public GetObjectsRequest withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.getQueryParams().put("page_offset", Integer.toString(pageOffset));
        return this;
    }

    public GetObjectsRequest withType(ObjectType objectType) {
        this.objectType = objectType;
        this.getQueryParams().put("type", objectType.toString().toLowerCase());
        return this;
    }

    public GetObjectsRequest withVersion(long version) {
        this.version = version;
        this.getQueryParams().put("version", Long.toString(version));
        return this;
    }

    public String getBucket() {
        return this.bucketName;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public long getVersion() {
        return this.version;
    }

    @Override
    public String getPath() {
        return "/_rest_/object/";
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    public static enum ObjectType {
        DATA,
        FOLDER;

    }
}

