/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.GetAvailableJobChunksRequest;
import com.spectralogic.ds3client.commands.GetAvailableJobChunksResponse;
import com.spectralogic.ds3client.commands.GetObjectRequest;
import com.spectralogic.ds3client.commands.GetObjectResponse;
import com.spectralogic.ds3client.exceptions.Ds3NoMoreRetriesException;
import com.spectralogic.ds3client.helpers.ChecksumFunction;
import com.spectralogic.ds3client.helpers.ChecksumListener;
import com.spectralogic.ds3client.helpers.ChunkTransferrer;
import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.JobImpl;
import com.spectralogic.ds3client.helpers.JobPartTracker;
import com.spectralogic.ds3client.helpers.JobPartTrackerFactory;
import com.spectralogic.ds3client.helpers.JobState;
import com.spectralogic.ds3client.helpers.MetadataReceivedListener;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.util.PartialObjectHelpers;
import com.spectralogic.ds3client.models.Checksum;
import com.spectralogic.ds3client.models.Range;
import com.spectralogic.ds3client.models.bulk.BulkObject;
import com.spectralogic.ds3client.models.bulk.MasterObjectList;
import com.spectralogic.ds3client.models.bulk.Objects;
import com.spectralogic.ds3client.networking.Metadata;
import com.spectralogic.ds3client.serializer.XmlProcessingException;
import com.spectralogic.ds3client.utils.Guard;
import java.io.IOException;
import java.security.SignatureException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadJobImpl
extends JobImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ReadJobImpl.class);
    private final JobPartTracker partTracker;
    private final List<Objects> chunks;
    private final ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> blobToRanges;
    private final int retryAfter;
    private int retryAfterLeft;
    private Map<MetadataReceivedListener, MetadataReceivedListener> metadataListeners;
    private Map<ChecksumListener, ChecksumListener> checksumListeners;

    public ReadJobImpl(Ds3Client client, MasterObjectList masterObjectList, ImmutableMultimap<String, Range> objectRanges, int retryAfter) {
        super(client, masterObjectList);
        this.chunks = this.masterObjectList.getObjects();
        this.partTracker = JobPartTrackerFactory.buildPartTracker(Iterables.concat(this.chunks));
        this.blobToRanges = PartialObjectHelpers.mapRangesToBlob(masterObjectList.getObjects(), objectRanges);
        this.retryAfter = this.retryAfterLeft = retryAfter;
        this.metadataListeners = new IdentityHashMap<MetadataReceivedListener, MetadataReceivedListener>();
        this.checksumListeners = new IdentityHashMap<ChecksumListener, ChecksumListener>();
    }

    @Override
    public void attachDataTransferredListener(DataTransferredListener listener) {
        this.checkRunning();
        this.partTracker.attachDataTransferredListener(listener);
    }

    @Override
    public void attachObjectCompletedListener(ObjectCompletedListener listener) {
        this.checkRunning();
        this.partTracker.attachObjectCompletedListener(listener);
    }

    @Override
    public void removeDataTransferredListener(DataTransferredListener listener) {
        this.checkRunning();
        this.partTracker.removeDataTransferredListener(listener);
    }

    @Override
    public void removeObjectCompletedListener(ObjectCompletedListener listener) {
        this.checkRunning();
        this.partTracker.removeObjectCompletedListener(listener);
    }

    @Override
    public void attachMetadataReceivedListener(MetadataReceivedListener listener) {
        this.checkRunning();
        this.metadataListeners.put(listener, listener);
    }

    @Override
    public void removeMetadataReceivedListener(MetadataReceivedListener listener) {
        this.checkRunning();
        this.metadataListeners.remove(listener);
    }

    @Override
    public void attachChecksumListener(ChecksumListener listener) {
        this.checkRunning();
        this.checksumListeners.put(listener, listener);
    }

    @Override
    public void removeChecksumListener(ChecksumListener listener) {
        this.checkRunning();
        this.checksumListeners.remove(listener);
    }

    @Override
    public Ds3ClientHelpers.Job withMetadata(Ds3ClientHelpers.MetadataAccess access) {
        throw new IllegalStateException("withMetadata method is not used with Read Jobs");
    }

    @Override
    public Ds3ClientHelpers.Job withChecksum(ChecksumFunction checksumFunction) {
        throw new IllegalStateException("withChecksum is not supported on Read Jobs");
    }

    @Override
    public void transfer(Ds3ClientHelpers.ObjectChannelBuilder channelBuilder) throws SignatureException, IOException, XmlProcessingException {
        this.running = true;
        try (JobState jobState = new JobState(channelBuilder, this.masterObjectList.getObjects(), this.partTracker, this.blobToRanges);){
            ChunkTransferrer chunkTransferrer = new ChunkTransferrer(new GetObjectTransferrer(jobState), this.client, jobState.getPartTracker(), this.maxParallelRequests);
            while (jobState.hasObjects()) {
                this.transferNextChunks(chunkTransferrer);
            }
        }
        catch (XmlProcessingException | IOException | RuntimeException | SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void transferNextChunks(ChunkTransferrer chunkTransferrer) throws IOException, SignatureException, XmlProcessingException, InterruptedException {
        GetAvailableJobChunksResponse availableJobChunks = this.client.getAvailableJobChunks(new GetAvailableJobChunksRequest(this.masterObjectList.getJobId()));
        switch (availableJobChunks.getStatus()) {
            case AVAILABLE: {
                MasterObjectList availableMol = availableJobChunks.getMasterObjectList();
                chunkTransferrer.transferChunks(availableMol.getNodes(), availableMol.getObjects());
                this.retryAfterLeft = this.retryAfter;
                break;
            }
            case RETRYLATER: {
                if (this.retryAfterLeft == 0) {
                    throw new Ds3NoMoreRetriesException(this.retryAfter);
                }
                --this.retryAfterLeft;
                Thread.sleep(availableJobChunks.getRetryAfterSeconds() * 1000);
                break;
            }
            default: {
                assert (false) : "This line of code should be impossible to hit.";
                break;
            }
        }
    }

    private void sendChecksumEvents(BulkObject ds3Object, Checksum.Type type, String checksum) {
        for (ChecksumListener listener : this.checksumListeners.values()) {
            listener.value(ds3Object, type, checksum);
        }
    }

    private void sendMetadataEvents(String objName, Metadata metadata) {
        for (MetadataReceivedListener listener : this.metadataListeners.values()) {
            listener.metadataReceived(objName, metadata);
        }
    }

    private static ImmutableCollection<Range> getRangesForBlob(ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> blobToRanges, BulkObject ds3Object) {
        ImmutableMultimap ranges = (ImmutableMultimap)blobToRanges.get((Object)ds3Object.getName());
        if (ranges == null) {
            return null;
        }
        return ranges.get((Object)ds3Object);
    }

    private final class GetObjectTransferrer
    implements ChunkTransferrer.ItemTransferrer {
        private final JobState jobState;

        private GetObjectTransferrer(JobState jobState) {
            this.jobState = jobState;
        }

        @Override
        public void transferItem(Ds3Client client, BulkObject ds3Object) throws SignatureException, IOException {
            ImmutableCollection ranges = ReadJobImpl.getRangesForBlob((ImmutableMap<String, ImmutableMultimap<BulkObject, Range>>)ReadJobImpl.this.blobToRanges, ds3Object);
            GetObjectRequest request = new GetObjectRequest(ReadJobImpl.this.masterObjectList.getBucketName(), ds3Object.getName(), ds3Object.getOffset(), ReadJobImpl.this.getJobId(), this.jobState.getChannel(ds3Object.getName(), ds3Object.getOffset(), ds3Object.getLength()));
            if (Guard.isNotNullAndNotEmpty(ranges)) {
                request.withByteRanges((Collection<Range>)ranges);
            }
            GetObjectResponse response = client.getObject(request);
            Metadata metadata = response.getMetadata();
            ReadJobImpl.this.sendChecksumEvents(ds3Object, response.getChecksumType(), response.getChecksum());
            ReadJobImpl.this.sendMetadataEvents(ds3Object.getName(), metadata);
        }
    }
}

