/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.models;

import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;

public abstract class Checksum {
    private static final Checksum none = new None();
    private static final Checksum compute = new Compute();

    public static Checksum none() {
        return none;
    }

    public static Checksum compute() {
        return compute;
    }

    public static Checksum value(String hash) {
        return new Value(hash);
    }

    public static Checksum value(byte[] hash) {
        String hashStr = Base64.encodeBase64String((byte[])hash);
        return new Value(hashStr);
    }

    public abstract <T, E extends Throwable> T match(MatchHandler<T, E> var1) throws E;

    private Checksum() {
    }

    private static class Value
    extends Checksum {
        private final String hash;

        public Value(String hash) {
            this.hash = hash;
        }

        @Override
        public <T, E extends Throwable> T match(MatchHandler<T, E> handler) throws E {
            return handler.value(this.hash.getBytes(Charset.forName("UTF-8")));
        }
    }

    private static class Compute
    extends Checksum {
        private Compute() {
        }

        @Override
        public <T, E extends Throwable> T match(MatchHandler<T, E> handler) throws E {
            return handler.compute();
        }
    }

    private static class None
    extends Checksum {
        private None() {
        }

        @Override
        public <T, E extends Throwable> T match(MatchHandler<T, E> handler) throws E {
            return handler.none();
        }
    }

    public static interface MatchHandler<T, E extends Throwable> {
        public T none() throws E;

        public T compute() throws E;

        public T value(byte[] var1) throws E;
    }

    public static enum Type {
        MD5,
        SHA256,
        SHA512,
        CRC32,
        CRC32C,
        NONE;

    }
}

