/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class IOUtils {
    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        long totalBytes = 0L;
        while ((len = inputStream.read(buffer)) != -1) {
            totalBytes += (long)len;
            outputStream.write(buffer, 0, len);
        }
        return totalBytes;
    }

    public static long copy(InputStream inputStream, WritableByteChannel writableByteChannel, int bufferSize) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        long totalBytes = 0L;
        while ((len = inputStream.read(buffer)) != -1) {
            totalBytes += (long)len;
            byteBuffer.position(0);
            byteBuffer.limit(len);
            writableByteChannel.write(byteBuffer);
        }
        return totalBytes;
    }
}

