/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.google.common.collect.ImmutableSet;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.GetJobRequest;
import com.spectralogic.ds3client.commands.GetJobResponse;
import com.spectralogic.ds3client.commands.GetJobsRequest;
import com.spectralogic.ds3client.commands.GetJobsResponse;
import com.spectralogic.ds3client.models.bulk.BulkObject;
import com.spectralogic.ds3client.models.bulk.JobInfo;
import com.spectralogic.ds3client.models.bulk.JobStatus;
import com.spectralogic.ds3client.models.bulk.MasterObjectList;
import com.spectralogic.ds3client.models.bulk.Objects;
import com.spectralogic.ds3client.models.bulk.RequestType;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class JobUtils {
    private JobUtils() {
    }

    public static List<UUID> findJob(Ds3Client client, RequestType type, String bucketName, Set<String> fileNames) throws IOException, SignatureException {
        ImmutableSet files = ImmutableSet.copyOf(fileNames);
        GetJobsResponse response = client.getJobs(new GetJobsRequest());
        ArrayList<UUID> jobs = new ArrayList<UUID>();
        block0: for (JobInfo jobInfo : response.getJobs()) {
            if (!jobInfo.getBucketName().equals(bucketName) || jobInfo.getStatus() != JobStatus.IN_PROGRESS || jobInfo.getRequestType() != type) continue;
            GetJobResponse jobResponse = client.getJob(new GetJobRequest(jobInfo.getJobId()));
            MasterObjectList mol = jobResponse.getMasterObjectList();
            for (Objects chunk : mol.getObjects()) {
                if (!JobUtils.chunkAndSetIntersects(chunk, (ImmutableSet<String>)files)) continue;
                jobs.add(jobInfo.getJobId());
                continue block0;
            }
        }
        return jobs;
    }

    private static boolean chunkAndSetIntersects(Objects chunk, ImmutableSet<String> fileNames) {
        for (BulkObject bulkObject : chunk.getObjects()) {
            if (!fileNames.contains((Object)bulkObject.getName())) continue;
            return true;
        }
        return false;
    }
}

