/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPMlsdListResponseReader;
import ch.cyberduck.core.ftp.FTPSession;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPReply;

public class FTPAttributesFinderFeature
implements AttributesFinder {
    private final FTPSession session;

    public FTPAttributesFinderFeature(FTPSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            if (((FTPClient)((Object)this.session.getClient())).hasFeature(FTPCmd.MLST.getCommand())) {
                if (!FTPReply.isPositiveCompletion((int)((FTPClient)((Object)this.session.getClient())).sendCommand(FTPCmd.MLST, file.getAbsolute()))) {
                    throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
                }
                FTPMlsdListResponseReader reader = new FTPMlsdListResponseReader();
                AttributedList<Path> attributes = reader.read(file.getParent(), Arrays.asList(((FTPClient)((Object)this.session.getClient())).getReplyStrings()), (ListProgressListener)new DisabledListProgressListener());
                if (attributes.contains((Referenceable)file)) {
                    return ((Path)attributes.iterator().next()).attributes();
                }
            }
            throw new InteroperabilityException("No support for MLST in reply to FEAT");
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        return this;
    }
}

