/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.DisabledPasswordStore;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginConnectionService;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.ftp.DataConnectionAction;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FTPDataFallback {
    private static final Logger log = Logger.getLogger(FTPDataFallback.class);
    private final FTPSession session;
    private final HostPasswordStore keychain;
    private final LoginCallback prompt;
    private final Preferences preferences = PreferencesFactory.get();

    public FTPDataFallback(FTPSession session) {
        this(session, (HostPasswordStore)new DisabledPasswordStore(), (LoginCallback)new DisabledLoginCallback());
    }

    public FTPDataFallback(FTPSession session, HostPasswordStore keychain, LoginCallback prompt) {
        this.session = session;
        this.keychain = keychain;
        this.prompt = prompt;
    }

    protected <T> T data(DataConnectionAction<T> action, ProgressListener listener) throws IOException, BackgroundException {
        try {
            FTPConnectMode mode = this.session.getConnectMode();
            switch (mode) {
                case active: {
                    ((FTPClient)((Object)this.session.getClient())).enterLocalActiveMode();
                    break;
                }
                case passive: {
                    ((FTPClient)((Object)this.session.getClient())).enterLocalPassiveMode();
                }
            }
            return action.execute();
        }
        catch (ConnectionTimeoutException failure) {
            log.warn((Object)String.format("Timeout opening data socket %s", failure.getMessage()));
            if (this.preferences.getBoolean("ftp.connectmode.fallback")) {
                try {
                    try {
                        ((FTPClient)((Object)this.session.getClient())).completePendingCommand();
                        log.warn((Object)String.format("Aborted connection %d %s", ((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString()));
                    }
                    catch (IOException e) {
                        log.warn((Object)String.format("Ignore failure completing pending command %s", e.getMessage()));
                        new LoginConnectionService(this.prompt, (HostKeyCallback)new DisabledHostKeyCallback(), this.keychain, listener).connect((Session)this.session, (Cache)PathCache.empty(), (CancelCallback)new DisabledCancelCallback());
                    }
                    return this.fallback(action);
                }
                catch (BackgroundException e) {
                    log.warn((Object)String.format("Connect mode fallback failed with %s", e.getMessage()));
                }
            }
            throw failure;
        }
        catch (AccessDeniedException | InteroperabilityException | NotfoundException failure) {
            log.warn((Object)String.format("Server denied data socket operation with %s", failure.getMessage()));
            if (this.preferences.getBoolean("ftp.connectmode.fallback")) {
                try {
                    return this.fallback(action);
                }
                catch (BackgroundException e) {
                    log.warn((Object)String.format("Connect mode fallback failed with %s", e.getMessage()));
                }
            }
            throw failure;
        }
    }

    protected <T> T fallback(DataConnectionAction<T> action) throws BackgroundException {
        if (((FTPClient)((Object)this.session.getClient())).getDataConnectionMode() == 2) {
            log.warn((Object)"Fallback to active data connection");
            ((FTPClient)((Object)this.session.getClient())).enterLocalActiveMode();
        } else if (((FTPClient)((Object)this.session.getClient())).getDataConnectionMode() == 0) {
            log.warn((Object)"Fallback to passive data connection");
            ((FTPClient)((Object)this.session.getClient())).enterLocalPassiveMode();
        }
        return action.execute();
    }
}

