/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionRefusedException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.QuotaException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.ftp.FTPException;
import java.io.IOException;
import java.time.Duration;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ftp.FTPConnectionClosedException;

public class FTPExceptionMappingService
extends AbstractExceptionMappingService<IOException> {
    public BackgroundException map(IOException e) {
        StringBuilder buffer = new StringBuilder();
        this.append(buffer, e.getMessage());
        if (e instanceof FTPConnectionClosedException) {
            return new ConnectionRefusedException(buffer.toString(), (Throwable)e);
        }
        if (e instanceof FTPException) {
            return this.handle((FTPException)e, buffer);
        }
        if (e instanceof MalformedServerReplyException) {
            return new InteroperabilityException(buffer.toString(), (Throwable)e);
        }
        return new DefaultIOExceptionMappingService().map(e);
    }

    private BackgroundException handle(FTPException e, StringBuilder buffer) {
        int status = e.getCode();
        switch (status) {
            case 452: 
            case 552: {
                return new QuotaException(buffer.toString(), (Throwable)e);
            }
            case 530: {
                return new LoginFailureException(buffer.toString(), (Throwable)e);
            }
            case 332: 
            case 451: 
            case 532: 
            case 533: 
            case 535: 
            case 553: {
                return new AccessDeniedException(buffer.toString(), (Throwable)e);
            }
            case 431: 
            case 550: {
                return new NotfoundException(buffer.toString(), (Throwable)e);
            }
            case 421: {
                Duration delay = Duration.ofSeconds(1L);
                return new RetriableAccessDeniedException(buffer.toString(), delay, (Throwable)e);
            }
        }
        return new InteroperabilityException(buffer.toString(), (Throwable)e);
    }
}

