/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.ftp.FTPDataResponseReader;
import ch.cyberduck.core.ftp.FTPInvalidListException;
import ch.cyberduck.core.ftp.parser.FTPExtendedFile;
import java.io.IOException;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.log4j.Logger;

public class FTPListResponseReader
implements FTPDataResponseReader {
    private static final Logger log = Logger.getLogger(FTPListResponseReader.class);
    private final FTPFileEntryParser parser;
    private final boolean lenient;

    public FTPListResponseReader(FTPFileEntryParser parser) {
        this(parser, false);
    }

    public FTPListResponseReader(FTPFileEntryParser parser, boolean lenient) {
        this.parser = parser;
        this.lenient = lenient;
    }

    @Override
    public AttributedList<Path> read(Path directory, List<String> replies, ListProgressListener listener) throws IOException, FTPInvalidListException, ConnectionCanceledException {
        AttributedList children = new AttributedList();
        boolean success = false;
        this.parser.preParse(replies);
        for (String line : replies) {
            FTPFile f = this.parser.parseFTPEntry(line);
            if (null == f) continue;
            String name = f.getName();
            if (!success && this.lenient) {
                if (directory.getName().equals(name)) {
                    log.warn((Object)String.format("Skip %s matching parent directory name", f.getName()));
                    continue;
                }
                if (name.contains(String.valueOf('/')) && !name.startsWith(directory.getAbsolute() + '/')) {
                    log.warn((Object)String.format("Skip %s with delimiter in name", name));
                    continue;
                }
            }
            success = true;
            if (name.equals(".") || name.equals("..")) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Skip %s", f.getName()));
                continue;
            }
            Path parsed = new Path(directory, PathNormalizer.name((String)name), f.getType() == 1 ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file));
            switch (f.getType()) {
                case 2: {
                    parsed.setType(EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.symboliclink));
                    String target = f.getLink();
                    if (StringUtils.isBlank((CharSequence)target)) {
                        log.warn((Object)String.format("Missing symbolic link target for %s", parsed));
                        EnumSet type = parsed.getType();
                        type.remove(AbstractPath.Type.symboliclink);
                        break;
                    }
                    if (StringUtils.startsWith((CharSequence)target, (CharSequence)String.valueOf('/'))) {
                        parsed.setSymlinkTarget(new Path(target, EnumSet.of(AbstractPath.Type.file)));
                        break;
                    }
                    if (StringUtils.equals((CharSequence)"..", (CharSequence)target)) {
                        parsed.setSymlinkTarget(directory);
                        break;
                    }
                    if (StringUtils.equals((CharSequence)".", (CharSequence)target)) {
                        parsed.setSymlinkTarget(parsed);
                        break;
                    }
                    parsed.setSymlinkTarget(new Path(directory, target, EnumSet.of(AbstractPath.Type.file)));
                }
            }
            if (parsed.isFile()) {
                parsed.attributes().setSize(f.getSize());
            }
            parsed.attributes().setOwner(f.getUser());
            parsed.attributes().setGroup(f.getGroup());
            Permission.Action u = Permission.Action.none;
            if (f.hasPermission(0, 0)) {
                u = u.or(Permission.Action.read);
            }
            if (f.hasPermission(0, 1)) {
                u = u.or(Permission.Action.write);
            }
            if (f.hasPermission(0, 2)) {
                u = u.or(Permission.Action.execute);
            }
            Permission.Action g = Permission.Action.none;
            if (f.hasPermission(1, 0)) {
                g = g.or(Permission.Action.read);
            }
            if (f.hasPermission(1, 1)) {
                g = g.or(Permission.Action.write);
            }
            if (f.hasPermission(1, 2)) {
                g = g.or(Permission.Action.execute);
            }
            Permission.Action o = Permission.Action.none;
            if (f.hasPermission(2, 0)) {
                o = o.or(Permission.Action.read);
            }
            if (f.hasPermission(2, 1)) {
                o = o.or(Permission.Action.write);
            }
            if (f.hasPermission(2, 2)) {
                o = o.or(Permission.Action.execute);
            }
            Permission permission = new Permission(u, g, o);
            if (f instanceof FTPExtendedFile) {
                permission.setSetuid(((FTPExtendedFile)f).isSetuid());
                permission.setSetgid(((FTPExtendedFile)f).isSetgid());
                permission.setSticky(((FTPExtendedFile)f).isSticky());
            }
            parsed.attributes().setPermission(permission);
            Calendar timestamp = f.getTimestamp();
            if (timestamp != null) {
                parsed.attributes().setModificationDate(timestamp.getTimeInMillis());
            }
            children.add((Referenceable)parsed);
        }
        if (!success) {
            throw new FTPInvalidListException((AttributedList<Path>)children);
        }
        return children;
    }
}

