/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPDataResponseReader;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPListResponseReader;
import ch.cyberduck.core.ftp.FTPListService;
import ch.cyberduck.core.ftp.FTPSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class FTPStatListService
implements ListService {
    private static final Logger log = Logger.getLogger(FTPListService.class);
    private final FTPSession session;
    private final FTPDataResponseReader reader;

    public FTPStatListService(FTPSession session, FTPFileEntryParser parser) {
        this.session = session;
        this.reader = new FTPListResponseReader(parser, true);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            int response = ((FTPClient)((Object)this.session.getClient())).stat(directory.getAbsolute());
            if (FTPReply.isPositiveCompletion((int)response)) {
                return this.reader.read(directory, this.parse(response, ((FTPClient)((Object)this.session.getClient())).getReplyStrings()), listener);
            }
            throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    protected List<String> parse(int response, String[] reply) {
        ArrayList<String> result = new ArrayList<String>(reply.length);
        for (String line : reply) {
            if (line.startsWith(String.valueOf(response))) {
                try {
                    String stripped = line;
                    stripped = StringUtils.strip((String)StringUtils.removeStart((String)stripped, (String)String.valueOf(String.format("%d-", response))));
                    stripped = StringUtils.strip((String)StringUtils.removeStart((String)stripped, (String)String.valueOf(response)));
                    result.add(stripped);
                }
                catch (IndexOutOfBoundsException e) {
                    log.error((Object)String.format("Failed parsing line %s", line), (Throwable)e);
                }
                continue;
            }
            result.add(StringUtils.strip((String)line));
        }
        return result;
    }
}

