/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.cdn.features.DistributionLogging;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.logging.LoggingConfiguration;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3LoggingFeature;
import ch.cyberduck.core.s3.S3Session;
import org.apache.commons.lang3.StringUtils;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.acl.gs.GroupByEmailAddressGrantee;
import org.jets3t.service.model.GSBucketLoggingStatus;
import org.jets3t.service.model.StorageBucketLoggingStatus;

public class GoogleStorageLoggingFeature
extends S3LoggingFeature
implements DistributionLogging {
    final GoogleStorageSession session;

    public GoogleStorageLoggingFeature(GoogleStorageSession session) {
        super((S3Session)session);
        this.session = session;
    }

    public void setConfiguration(Path container, LoggingConfiguration configuration) throws BackgroundException {
        try {
            GroupByEmailAddressGrantee grantee;
            AccessControlList acl;
            GSBucketLoggingStatus status = new GSBucketLoggingStatus(StringUtils.isNotBlank((CharSequence)configuration.getLoggingTarget()) ? configuration.getLoggingTarget() : container.getName(), null);
            if (configuration.isEnabled()) {
                status.setLogfilePrefix(PreferencesFactory.get().getProperty("google.logging.prefix"));
            }
            if (!(acl = ((RequestEntityRestStorageService)this.session.getClient()).getBucketAcl(container.getName())).getPermissionsForGrantee((GranteeInterface)(grantee = new GroupByEmailAddressGrantee("cloud-storage-analytics@google.com"))).contains(Permission.PERMISSION_WRITE)) {
                acl.grantPermission((GranteeInterface)grantee, Permission.PERMISSION_WRITE);
                ((RequestEntityRestStorageService)this.session.getClient()).putBucketAcl(container.getName(), acl);
            }
            ((RequestEntityRestStorageService)this.session.getClient()).setBucketLoggingStatusImpl(container.getName(), (StorageBucketLoggingStatus)status);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Failure to write attributes of {0}", (Throwable)e);
        }
    }
}

