/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.hubic;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.openstack.SwiftProtocol;
import ch.cyberduck.core.preferences.PreferencesFactory;

public class HubicProtocol
extends AbstractProtocol {
    public String getIdentifier() {
        return "hubic";
    }

    public String getDescription() {
        return "hubiC";
    }

    public Scheme getScheme() {
        return Scheme.https;
    }

    public Protocol.Type getType() {
        return Protocol.Type.swift;
    }

    public String getPrefix() {
        return String.format("%s.%s", HubicProtocol.class.getPackage().getName(), "Hubic");
    }

    public String getDefaultHostname() {
        return "api.hubic.com";
    }

    public boolean isHostnameConfigurable() {
        return false;
    }

    public boolean isPortConfigurable() {
        return false;
    }

    public boolean isAnonymousConfigurable() {
        return false;
    }

    public String getUsernamePlaceholder() {
        return "Email";
    }

    public String getPasswordPlaceholder() {
        return LocaleFactory.localizedString((String)"Authorization code", (String)"Credentials");
    }

    public boolean isPasswordConfigurable() {
        return false;
    }

    public boolean isEnabled() {
        return false;
    }

    public String disk() {
        return new SwiftProtocol().disk();
    }

    public String icon() {
        return new SwiftProtocol().icon();
    }

    public boolean validate(Credentials credentials, LoginOptions options) {
        return true;
    }

    public String getClientId() {
        return PreferencesFactory.get().getProperty("hubic.oauth.clientid");
    }

    public String getClientSecret() {
        return PreferencesFactory.get().getProperty("hubic.oauth.secret");
    }
}

