/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.hubic;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.hubic.HubicAuthenticationRequest;
import ch.cyberduck.core.hubic.HubicAuthenticationResponseHandler;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.ProxyFinder;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.method.AuthenticationRequest;
import java.io.IOException;
import java.util.Collections;
import javax.net.SocketFactory;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class HubicSession
extends SwiftSession {
    private static final Logger log = Logger.getLogger(HubicSession.class);
    private final OAuth2RequestInterceptor authorizationService;
    private final OAuth2ErrorResponseInterceptor retryHandler;

    public HubicSession(Host host) {
        super(host);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build((TranscriptListener)this).build(), "https://api.hubic.com/oauth/token", "https://api.hubic.com/oauth/auth", this.host.getProtocol().getClientId(), this.host.getProtocol().getClientSecret(), Collections.singletonList("credentials.r")).withRedirectUri(PreferencesFactory.get().getProperty("hubic.oauth.redirecturi"));
        this.retryHandler = new OAuth2ErrorResponseInterceptor(this.authorizationService);
    }

    public HubicSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build((TranscriptListener)this).build(), "https://api.hubic.com/oauth/token", "https://api.hubic.com/oauth/auth", this.host.getProtocol().getClientId(), this.host.getProtocol().getClientSecret(), Collections.singletonList("credentials.r")).withRedirectUri(PreferencesFactory.get().getProperty("hubic.oauth.redirecturi"));
        this.retryHandler = new OAuth2ErrorResponseInterceptor(this.authorizationService);
    }

    public HubicSession(Host host, X509TrustManager trust, X509KeyManager key, ProxyFinder proxy) {
        super(host, trust, key, proxy);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build((TranscriptListener)this).build(), "https://api.hubic.com/oauth/token", "https://api.hubic.com/oauth/auth", this.host.getProtocol().getClientId(), this.host.getProtocol().getClientSecret(), Collections.singletonList("credentials.r")).withRedirectUri(PreferencesFactory.get().getProperty("hubic.oauth.redirecturi"));
        this.retryHandler = new OAuth2ErrorResponseInterceptor(this.authorizationService);
    }

    public HubicSession(Host host, X509TrustManager trust, X509KeyManager key, SocketFactory socketFactory) {
        super(host, trust, key, socketFactory);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build((TranscriptListener)this).build(), "https://api.hubic.com/oauth/token", "https://api.hubic.com/oauth/auth", this.host.getProtocol().getClientId(), this.host.getProtocol().getClientSecret(), Collections.singletonList("credentials.r")).withRedirectUri(PreferencesFactory.get().getProperty("hubic.oauth.redirecturi"));
        this.retryHandler = new OAuth2ErrorResponseInterceptor(this.authorizationService);
    }

    public Client connect(HostKeyCallback key) throws BackgroundException {
        HttpClientBuilder configuration = this.builder.build((TranscriptListener)this);
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)this.retryHandler);
        return new Client(configuration.build());
    }

    public void login(HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel, Cache<Path> cache) throws BackgroundException {
        OAuth2AuthorizationService.Tokens tokens = this.authorizationService.authorize(this.host, keychain, prompt, cancel);
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Attempt authentication with %s", tokens));
            }
            ((Client)this.client).authenticate((AuthenticationRequest)new HubicAuthenticationRequest(tokens.getAccessToken()), (ResponseHandler)new HubicAuthenticationResponseHandler());
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == DistributionConfiguration.class) {
            return null;
        }
        return (T)super._getFeature(type);
    }
}

