/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.googlestorage.GoogleStorageProtocol;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import ch.cyberduck.core.s3.S3Protocol;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public abstract class CloudberryBookmarkCollection
extends XmlBookmarkCollection {
    private static final Logger log = Logger.getLogger(CloudberryBookmarkCollection.class);
    private static final long serialVersionUID = 2245328157886337606L;

    @Override
    protected XmlBookmarkCollection.AbstractHandler getHandler() {
        return new ServerHandler();
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private Host current = null;

        private ServerHandler() {
        }

        @Override
        public void startElement(String name, Attributes attrs) {
            block3 : switch (name) {
                case "Settings": {
                    String type;
                    switch (type = attrs.getValue("xsi:type")) {
                        case "GoogleSettings": {
                            this.current = new Host((Protocol)new GoogleStorageProtocol(), new GoogleStorageProtocol().getDefaultHostname(), new GoogleStorageProtocol().getDefaultPort());
                            break block3;
                        }
                        case "S3Settings": {
                            this.current = new Host((Protocol)new S3Protocol(), new S3Protocol().getDefaultHostname(), new S3Protocol().getDefaultPort());
                            break block3;
                        }
                        case "DunkelSettings": {
                            this.current = new Host((Protocol)new S3Protocol(), new S3Protocol().getDefaultHostname(), new S3Protocol().getDefaultPort());
                            break block3;
                        }
                    }
                    log.warn((Object)("Unsupported connection type:" + type));
                }
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            if (null == this.current) {
                return;
            }
            switch (name) {
                case "ServicePoint": {
                    this.current.setHostname(elementText);
                    break;
                }
                case "AWSKey": {
                    this.current.getCredentials().setUsername(elementText);
                    break;
                }
                case "Account": {
                    this.current.getCredentials().setUsername(elementText);
                    break;
                }
                case "SharedKey": {
                    this.current.getCredentials().setPassword(elementText);
                    break;
                }
                case "Name": {
                    this.current.setNickname(elementText);
                    break;
                }
                case "Settings": {
                    CloudberryBookmarkCollection.this.add(this.current);
                    this.current = null;
                }
            }
        }
    }
}

