/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.dav.DAVProtocol;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.ftp.FTPProtocol;
import ch.cyberduck.core.ftp.FTPTLSProtocol;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3Protocol;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class CrossFtpBookmarkCollection
extends XmlBookmarkCollection {
    private static final Logger log = Logger.getLogger(CrossFtpBookmarkCollection.class);
    private static final long serialVersionUID = 7442378118872253601L;

    @Override
    public String getBundleIdentifier() {
        return "com.crossftp";
    }

    @Override
    public String getName() {
        return "CrossFTP";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.crossftp.location"));
    }

    @Override
    protected XmlBookmarkCollection.AbstractHandler getHandler() {
        return new ServerHandler();
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private Host current = null;

        private ServerHandler() {
        }

        @Override
        public void startElement(String name, Attributes attrs) {
            switch (name) {
                case "site": {
                    this.current = new Host((Protocol)new FTPProtocol(), attrs.getValue("hName"));
                    this.current.setNickname(attrs.getValue("name"));
                    this.current.getCredentials().setUsername(attrs.getValue("un"));
                    this.current.setWebURL(attrs.getValue("wURL"));
                    this.current.setComment(attrs.getValue("comm"));
                    this.current.setDefaultPath(attrs.getValue("path"));
                    String protocol = attrs.getValue("ftpPType");
                    try {
                        switch (Integer.valueOf(protocol)) {
                            case 1: {
                                this.current.setProtocol((Protocol)new FTPProtocol());
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: {
                                this.current.setProtocol((Protocol)new FTPTLSProtocol());
                                break;
                            }
                            case 6: {
                                this.current.setProtocol((Protocol)new DAVProtocol());
                                break;
                            }
                            case 7: {
                                this.current.setProtocol((Protocol)new DAVSSLProtocol());
                                break;
                            }
                            case 8: 
                            case 9: {
                                this.current.setProtocol((Protocol)new S3Protocol());
                            }
                        }
                        this.current.setPort(-1);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Unknown protocol:" + e.getMessage()));
                    }
                    try {
                        this.current.setPort(Integer.parseInt(attrs.getValue("port")));
                        break;
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Invalid Port:" + e.getMessage()));
                    }
                }
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            switch (name) {
                case "site": {
                    CrossFtpBookmarkCollection.this.add(this.current);
                }
            }
        }
    }
}

