/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.impl.jna.PlistDeserializer;
import java.util.List;

public class FetchBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final long serialVersionUID = -7544710198776572190L;

    @Override
    public String getBundleIdentifier() {
        return "com.fetchsoftworks.Fetch";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.fetch.location"));
    }

    @Override
    protected void parse(Local file) throws AccessDeniedException {
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            throw new LocalAccessDeniedException(String.format("Invalid bookmark file %s", file));
        }
        NSDictionary dict = new PlistDeserializer(serialized).objectForKey("Shortcuts v2");
        if (null == dict) {
            throw new LocalAccessDeniedException(String.format("Invalid bookmark file %s", file));
        }
        if (null == (dict = new PlistDeserializer(dict).objectForKey("Shortcuts"))) {
            throw new LocalAccessDeniedException(String.format("Invalid bookmark file %s", file));
        }
        List shortcuts = new PlistDeserializer(dict).listForKey("Shortcuts");
        for (NSDictionary shortcut : shortcuts) {
            String url;
            NSDictionary location;
            PlistDeserializer reader = new PlistDeserializer(shortcut);
            NSDictionary remote = reader.objectForKey("Remote Item");
            if (null == remote || null == (location = new PlistDeserializer(remote).objectForKey("Location")) || null == (url = new PlistDeserializer(location).stringForKey("URL"))) continue;
            Host host = HostParser.parse((String)url);
            host.setNickname(reader.stringForKey("Name"));
            this.add(host);
        }
    }
}

