/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.ftp.FTPProtocol;
import ch.cyberduck.core.ftp.FTPTLSProtocol;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.SFTPProtocol;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class FireFtpBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = Logger.getLogger(FireFtpBookmarkCollection.class);
    private static final long serialVersionUID = -1802799231453221690L;

    @Override
    public String getBundleIdentifier() {
        return "org.mozdev.fireftp";
    }

    @Override
    public String getName() {
        return "FireFTP";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.fireftp.location"));
    }

    @Override
    protected void parse(Local folder) throws AccessDeniedException {
        for (Local settings : folder.list().filter((Filter)new NullFilter<Local>(){

            public boolean accept(Local file) {
                return file.isDirectory();
            }
        })) {
            for (Local child : settings.list().filter((Filter)new NullFilter<Local>(){

                public boolean accept(Local file) {
                    if (file.isFile()) {
                        return "fireFTPsites.dat".equals(file.getName());
                    }
                    return false;
                }
            })) {
                this.read(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(Local file) throws AccessDeniedException {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream(), Charset.forName("UTF-8")));
            try {
                String l;
                while ((l = in.readLine()) != null) {
                    Matcher array = Pattern.compile("\\[(.*?)\\]").matcher(l);
                    while (array.find()) {
                        Matcher entries = Pattern.compile("\\{(.*?)\\}").matcher(array.group(1));
                        while (entries.find()) {
                            String entry = entries.group(1);
                            this.read(entry);
                        }
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)in);
            }
        }
        catch (IOException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    private void read(String entry) {
        Host current = new Host((Protocol)new FTPProtocol(), PreferencesFactory.get().getProperty("connection.hostname.default"));
        current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
        for (String attribute : entry.split(", ")) {
            Scanner scanner = new Scanner(attribute);
            scanner.useDelimiter(":");
            if (!scanner.hasNext()) {
                log.warn((Object)("Missing key in line:" + attribute));
                continue;
            }
            String name = scanner.next().toLowerCase(Locale.ROOT);
            if (!scanner.hasNext()) {
                log.warn((Object)("Missing value in line:" + attribute));
                continue;
            }
            String value = scanner.next().replaceAll("\"", "");
            if ("host".equals(name)) {
                current.setHostname(value);
                continue;
            }
            if ("port".equals(name)) {
                try {
                    current.setPort(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Invalid Port:" + e.getMessage()));
                }
                continue;
            }
            if ("remotedir".equals(name)) {
                current.setDefaultPath(value);
                continue;
            }
            if ("webhost".equals(name)) {
                current.setWebURL(value);
                continue;
            }
            if ("encoding".equals(name)) {
                current.setEncoding(value);
                continue;
            }
            if ("notes".equals(name)) {
                current.setComment(value);
                continue;
            }
            if ("account".equals(name)) {
                current.setNickname(value);
                continue;
            }
            if ("privatekey".equals(name)) {
                current.getCredentials().setIdentity(LocalFactory.get((String)value));
                continue;
            }
            if ("pasvmode".equals(name)) {
                if (Boolean.TRUE.toString().equals(value)) {
                    current.setFTPConnectMode(FTPConnectMode.passive);
                }
                if (!Boolean.FALSE.toString().equals(value)) continue;
                current.setFTPConnectMode(FTPConnectMode.active);
                continue;
            }
            if ("login".equals(name)) {
                current.getCredentials().setUsername(value);
                continue;
            }
            if ("password".equals(name)) {
                current.getCredentials().setPassword(value);
                continue;
            }
            if ("anonymous".equals(name)) {
                if (!Boolean.TRUE.toString().equals(value)) continue;
                current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
                continue;
            }
            if (!"security".equals(name)) continue;
            if ("authtls".equals(value)) {
                current.setProtocol((Protocol)new FTPTLSProtocol());
                current.setPort(-1);
            }
            if (!"sftp".equals(value)) continue;
            current.setProtocol((Protocol)new SFTPProtocol());
            current.setPort(-1);
        }
        this.add(current);
    }
}

