/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.ftp.FTPTLSProtocol;
import ch.cyberduck.core.googledrive.DriveProtocol;
import ch.cyberduck.core.googlestorage.GoogleStorageProtocol;
import ch.cyberduck.core.hubic.HubicProtocol;
import ch.cyberduck.core.importer.JsonBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class NetDrive2BookmarkCollection
extends JsonBookmarkCollection {
    private static final Logger log = Logger.getLogger(NetDrive2BookmarkCollection.class);

    @Override
    public String getName() {
        return "NetDrive 2";
    }

    @Override
    public String getBundleIdentifier() {
        return "net.netdrive.NetDrive2";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.netdrive2.location"));
    }

    @Override
    protected void parse(Local file) throws AccessDeniedException {
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(file.getInputStream(), "UTF-8"));
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                boolean skip = false;
                String url = null;
                boolean ssl = false;
                FTPTLSProtocol protocol = null;
                String user = null;
                block29: while (reader.hasNext()) {
                    String name;
                    block7 : switch (name = reader.nextName()) {
                        case "url": {
                            url = this.readNext(name, reader);
                            if (!StringUtils.isBlank((CharSequence)url)) continue block29;
                            skip = true;
                            break;
                        }
                        case "ssl": {
                            ssl = reader.nextBoolean();
                            break;
                        }
                        case "user": {
                            user = this.readNext(name, reader);
                            break;
                        }
                        case "type": {
                            String type;
                            switch (type = this.readNext(name, reader)) {
                                case "hubic": {
                                    protocol = new HubicProtocol();
                                    break block7;
                                }
                                case "google_cloud_storage": {
                                    protocol = new GoogleStorageProtocol();
                                    break block7;
                                }
                                case "gdrive": {
                                    protocol = new DriveProtocol();
                                    break block7;
                                }
                            }
                            protocol = ProtocolFactory.forName((String)type);
                            break;
                        }
                        default: {
                            log.warn((Object)String.format("Ignore property %s", name));
                            reader.skipValue();
                        }
                    }
                }
                reader.endObject();
                if (skip || protocol == null || !StringUtils.isNotBlank(user)) continue;
                if (ssl) {
                    switch (protocol.getType()) {
                        case ftp: {
                            protocol = new FTPTLSProtocol();
                            break;
                        }
                        case dav: {
                            protocol = new DAVSSLProtocol();
                        }
                    }
                }
                this.add(HostParser.parse((ProtocolFactory)ProtocolFactory.global, protocol, url));
            }
            reader.endArray();
        }
        catch (IOException | IllegalStateException e) {
            throw new LocalAccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }
}

