/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3Protocol;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class S3BrowserBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = Logger.getLogger(S3BrowserBookmarkCollection.class);
    private static final long serialVersionUID = 2559948549693535359L;

    @Override
    public String getBundleIdentifier() {
        return "com.s3browser";
    }

    @Override
    public String getName() {
        return "S3Browser";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.s3browser.location"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parse(Local file) throws AccessDeniedException {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream(), Charset.forName("UTF-8")));
            try {
                String line;
                Host current = null;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("[account_")) {
                        current = new Host((Protocol)new S3Protocol(), new S3Protocol().getDefaultHostname(), new S3Protocol().getDefaultPort());
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)line)) {
                        this.add(current);
                        current = null;
                        continue;
                    }
                    if (null == current) {
                        log.warn((Object)"Failed to detect start of bookmark");
                        continue;
                    }
                    Scanner scanner = new Scanner(line);
                    scanner.useDelimiter(" = ");
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing key in line:" + line));
                        continue;
                    }
                    String name = scanner.next().toLowerCase(Locale.ROOT);
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing value in line:" + line));
                        continue;
                    }
                    String value = scanner.next();
                    if ("name".equals(name)) {
                        current.setNickname(value);
                        continue;
                    }
                    if ("comment".equals(name)) {
                        current.setComment(value);
                        continue;
                    }
                    if ("access_key".equals(name)) {
                        current.getCredentials().setUsername(value);
                        continue;
                    }
                    if (!"secret_key".equals(name)) continue;
                    current.getCredentials().setPassword(value);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)in);
            }
        }
        catch (IOException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }
}

