/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.text.MessageFormat;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class ThirdpartyBookmarkCollection
extends AbstractHostCollection {
    private static final Logger log = Logger.getLogger(ThirdpartyBookmarkCollection.class);
    private static final long serialVersionUID = -4582425984484543617L;
    private final Preferences preferences = PreferencesFactory.get();
    private final PasswordStore keychain;

    public ThirdpartyBookmarkCollection() {
        this.keychain = PasswordStoreFactory.get();
    }

    public ThirdpartyBookmarkCollection(PasswordStore keychain) {
        this.keychain = keychain;
    }

    public String getName() {
        Application application;
        ApplicationFinder finder = ApplicationFinderFactory.get();
        if (!finder.isInstalled(application = finder.getDescription(this.getBundleIdentifier()))) {
            return LocaleFactory.localizedString((String)"Unknown");
        }
        return application.getName();
    }

    public void load() throws AccessDeniedException {
        Local file = this.getFile();
        if (file.exists()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found bookmarks file at %s", file));
            }
            Checksum current = null;
            try {
                current = ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5).compute(file.getInputStream(), new TransferStatus());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Current checksum for %s is %s", file, current));
                }
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Failure obtaining checksum for %s", file));
            }
            if (this.preferences.getBoolean(this.getConfiguration())) {
                Checksum previous = new Checksum(HashAlgorithm.md5, this.preferences.getProperty(String.format("%s.checksum", this.getConfiguration())));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Saved previous checksum %s for bookmark %s", previous, file));
                }
                if (StringUtils.isNotBlank((CharSequence)previous.hash)) {
                    if (previous.equals((Object)current)) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Skip importing bookmarks from %s with previously saved checksum %s", file, previous));
                        }
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Checksum changed for bookmarks file at %s", file));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Skip importing bookmarks from %s", file));
                }
            } else {
                this.parse(file);
            }
            if (current != null) {
                this.preferences.setProperty(String.format("%s.checksum", this.getConfiguration()), current.hash);
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)String.format("No bookmarks file at %s", file));
        }
        super.load();
    }

    public abstract Local getFile();

    protected abstract void parse(Local var1) throws AccessDeniedException;

    public boolean isInstalled() {
        return StringUtils.isNotBlank((CharSequence)this.getName());
    }

    public abstract String getBundleIdentifier();

    public String getConfiguration() {
        return String.format("bookmark.import.%s", this.getBundleIdentifier());
    }

    public boolean add(Host bookmark) {
        Credentials credentials;
        if (null == bookmark) {
            log.warn((Object)"Parsing bookmark failed.");
            return false;
        }
        StringBuilder comment = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)bookmark.getComment())) {
            comment.append(bookmark.getComment());
            if (!comment.toString().endsWith(".")) {
                comment.append(".");
            }
            comment.append(" ");
        }
        comment.append(MessageFormat.format(LocaleFactory.localizedString((String)"Imported from {0}", (String)"Configuration"), this.getName()));
        bookmark.setComment(comment.toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Create new bookmark from import %s", bookmark));
        }
        if (StringUtils.isNotBlank((CharSequence)(credentials = bookmark.getCredentials()).getPassword())) {
            if (credentials.isPublicKeyAuthentication()) {
                this.keychain.addPassword(bookmark.getHostname(), credentials.getIdentity().getAbbreviatedPath(), credentials.getPassword());
            } else if (!credentials.isAnonymousLogin()) {
                this.keychain.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername(), credentials.getPassword());
                credentials.setPassword(null);
            }
        }
        return super.add(bookmark);
    }

    public void filter(AbstractHostCollection bookmarks) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Host i = (Host)iter.next();
            if (!bookmarks.find(i)) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Remove %s from import as we found it in bookmarks", i));
            }
            iter.remove();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ThirdpartyBookmarkCollection{");
        sb.append("file=").append(this.getFile());
        sb.append('}');
        return sb.toString();
    }
}

