/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.ftp.FTPProtocol;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TotalCommanderBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = Logger.getLogger(TotalCommanderBookmarkCollection.class);
    private static final long serialVersionUID = -1125641222323961118L;

    @Override
    public String getBundleIdentifier() {
        return "com.ghisler.totalcommander";
    }

    @Override
    public String getName() {
        return "Total Commander";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.totalcommander.location"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parse(Local file) throws AccessDeniedException {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream(), Charset.forName("UTF-8")));
            try {
                String line;
                Host current = null;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("[")) {
                        if (current != null) {
                            this.add(current);
                        }
                        current = new Host((Protocol)new FTPProtocol(), PreferencesFactory.get().getProperty("connection.hostname.default"));
                        current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
                        Pattern pattern = Pattern.compile("\\[(.*)\\]");
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.matches()) continue;
                        current.setNickname(matcher.group(1));
                        continue;
                    }
                    if (null == current) {
                        log.warn((Object)"Failed to detect start of bookmark");
                        continue;
                    }
                    Scanner scanner = new Scanner(line);
                    scanner.useDelimiter("=");
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing key in line:" + line));
                        continue;
                    }
                    String name = scanner.next().toLowerCase(Locale.ROOT);
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing value in line:" + line));
                        continue;
                    }
                    String value = scanner.next();
                    if ("host".equals(name)) {
                        current.setHostname(value);
                        continue;
                    }
                    if ("directory".equals(name)) {
                        current.setDefaultPath(value);
                        continue;
                    }
                    if ("username".equals(name)) {
                        current.getCredentials().setUsername(value);
                        continue;
                    }
                    log.warn((Object)String.format("Ignore property %s", name));
                }
                if (current != null) {
                    this.add(current);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)in);
            }
        }
        catch (IOException e) {
            throw new AccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean add(Host bookmark) {
        if (!StringUtils.equals((CharSequence)bookmark.getHostname(), (CharSequence)PreferencesFactory.get().getProperty("connection.hostname.default"))) {
            return super.add(bookmark);
        }
        return false;
    }
}

