/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.dav.DAVProtocol;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.ftp.FTPProtocol;
import ch.cyberduck.core.ftp.FTPTLSProtocol;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.sftp.SFTPProtocol;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class Transmit4BookmarkCollection
extends XmlBookmarkCollection {
    private static final Logger log = Logger.getLogger(Transmit4BookmarkCollection.class);

    @Override
    protected XmlBookmarkCollection.AbstractHandler getHandler() {
        return new FavoriteHandler();
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.transmit4.location"));
    }

    @Override
    public String getBundleIdentifier() {
        return "com.panic.Transmit";
    }

    private class FavoriteHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private Host current = null;
        private String attribute;

        private FavoriteHandler() {
        }

        @Override
        public void startElement(String name, Attributes attrs) {
            block4 : switch (name) {
                case "object": {
                    String type;
                    switch (type = attrs.getValue("type")) {
                        case "FAVORITE": {
                            this.current = new Host((Protocol)new FTPProtocol(), PreferencesFactory.get().getProperty("connection.hostname.default"));
                            break block4;
                        }
                    }
                    log.warn((Object)String.format("Unsupported type: %s", type));
                    break;
                }
                case "attribute": {
                    this.attribute = attrs.getValue("name");
                }
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            block43: {
                if (null == this.current) {
                    return;
                }
                block4 : switch (name) {
                    case "object": {
                        Transmit4BookmarkCollection.this.add(this.current);
                        this.current = null;
                        break;
                    }
                    case "attribute": {
                        switch (this.attribute) {
                            case "username": {
                                this.current.getCredentials().setUsername(elementText);
                                break block4;
                            }
                            case "server": {
                                this.current.setHostname(elementText);
                                break block4;
                            }
                            case "protocol": {
                                switch (StringUtils.lowerCase((String)elementText)) {
                                    case "webdav": {
                                        this.current.setProtocol((Protocol)new DAVProtocol());
                                        break;
                                    }
                                    case "webdavs": {
                                        this.current.setProtocol((Protocol)new DAVSSLProtocol());
                                        break;
                                    }
                                    case "sftp": {
                                        this.current.setProtocol((Protocol)new SFTPProtocol());
                                        break;
                                    }
                                    case "ftptls": 
                                    case "ftpssl": {
                                        this.current.setProtocol((Protocol)new FTPTLSProtocol());
                                        break;
                                    }
                                    case "ftp": {
                                        this.current.setProtocol((Protocol)new FTPProtocol());
                                        break;
                                    }
                                    case "s3": {
                                        this.current.setProtocol((Protocol)new S3Protocol());
                                    }
                                }
                                this.current.setPort(-1);
                                break block4;
                            }
                            case "port": {
                                Integer value = Integer.valueOf(elementText);
                                if (value > 0) {
                                    this.current.setPort(value.intValue());
                                    break block4;
                                }
                                break block43;
                            }
                            case "nickname": {
                                this.current.setNickname(elementText);
                                break block4;
                            }
                            case "initialremotepath": {
                                this.current.setDefaultPath(elementText);
                            }
                        }
                    }
                }
            }
        }
    }
}

