/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSData;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSKeyedUnarchiver;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.dav.DAVProtocol;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.ftp.FTPProtocol;
import ch.cyberduck.core.ftp.FTPTLSProtocol;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.sftp.SFTPProtocol;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;

public class TransmitBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = Logger.getLogger(TransmitBookmarkCollection.class);
    private static final long serialVersionUID = 6406786269501430927L;

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.transmit.location"));
    }

    @Override
    public String getBundleIdentifier() {
        return "com.panic.Transmit";
    }

    @Override
    protected void parse(Local file) throws AccessDeniedException {
        NSObject next;
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            throw new LocalAccessDeniedException(String.format("Invalid bookmark file %s", file));
        }
        TransmitFavoriteCollection c = (TransmitFavoriteCollection)Rococoa.createClass((String)"TransmitFavoriteCollection", TransmitFavoriteCollection.class);
        TransmitFavorite f = (TransmitFavorite)Rococoa.createClass((String)"TransmitFavorite", TransmitFavorite.class);
        NSData collectionsData = (NSData)Rococoa.cast((ObjCObject)serialized.objectForKey("FavoriteCollections"), NSData.class);
        if (null == collectionsData) {
            throw new LocalAccessDeniedException(String.format("Error unarchiving bookmark file %s", file));
        }
        NSKeyedUnarchiver reader = NSKeyedUnarchiver.createForReadingWithData((NSData)collectionsData);
        reader.setClass_forClassName((ObjCClass)c, "FavoriteCollection");
        reader.setClass_forClassName((ObjCClass)c, "HistoryCollection");
        reader.setClass_forClassName((ObjCClass)f, "Favorite");
        reader.setClass_forClassName((ObjCClass)f, "DotMacFavorite");
        if (!reader.containsValueForKey("FavoriteCollection")) {
            log.warn((Object)"Missing key FavoriteCollection");
            return;
        }
        TransmitFavoriteCollection rootCollection = (TransmitFavoriteCollection)Rococoa.cast((ObjCObject)reader.decodeObjectForKey("FavoriteCollection"), TransmitFavoriteCollection.class);
        reader.finishDecoding();
        if (null == rootCollection) {
            throw new LocalAccessDeniedException(String.format("Error unarchiving bookmark file %s", file));
        }
        NSArray collections = rootCollection.favorites();
        NSEnumerator collectionsEnumerator = collections.objectEnumerator();
        while ((next = collectionsEnumerator.nextObject()) != null) {
            NSObject favorite;
            TransmitFavoriteCollection collection = (TransmitFavoriteCollection)Rococoa.cast((ObjCObject)next, TransmitFavoriteCollection.class);
            if ("History".equals(collection.name())) continue;
            NSArray favorites = collection.favorites();
            NSEnumerator favoritesEnumerator = favorites.objectEnumerator();
            while ((favorite = favoritesEnumerator.nextObject()) != null) {
                this.parse((TransmitFavorite)Rococoa.cast((ObjCObject)favorite, TransmitFavorite.class));
            }
        }
    }

    private void parse(TransmitFavorite favorite) {
        String user;
        FTPProtocol protocol;
        String protocolstring;
        String server = favorite.server();
        if (StringUtils.isBlank((CharSequence)server)) {
            log.warn((Object)("No server name:" + server));
            return;
        }
        int port = favorite.port();
        if (0 == port) {
            port = -1;
        }
        if (StringUtils.isBlank((CharSequence)(protocolstring = favorite.protocol()))) {
            log.warn((Object)("Unknown protocol:" + protocolstring));
            return;
        }
        switch (protocolstring) {
            case "FTP": {
                protocol = new FTPProtocol();
                break;
            }
            case "SFTP": {
                protocol = new SFTPProtocol();
                break;
            }
            case "FTPTLS": 
            case "FTPSSL": {
                protocol = new FTPTLSProtocol();
                break;
            }
            case "S3": {
                protocol = new S3Protocol();
                break;
            }
            case "WebDAV": {
                protocol = new DAVProtocol();
                break;
            }
            case "WebDAVS": {
                protocol = new DAVSSLProtocol();
                break;
            }
            default: {
                log.warn((Object)String.format("Unknown protocol %s", protocolstring));
                return;
            }
        }
        Host bookmark = new Host((Protocol)protocol, server, port);
        String nickname = favorite.nickname();
        if (StringUtils.isNotBlank((CharSequence)nickname)) {
            bookmark.setNickname(nickname);
        }
        if (StringUtils.isNotBlank((CharSequence)(user = favorite.username()))) {
            bookmark.setCredentials(user, null);
        } else {
            bookmark.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
        }
        String path = favorite.path();
        if (StringUtils.isNotBlank((CharSequence)path)) {
            bookmark.setDefaultPath(path);
        }
        this.add(bookmark);
    }

    public static interface TransmitFavorite
    extends ObjCClass {
        public String server();

        public String nickname();

        public String username();

        public String protocol();

        public String path();

        public int port();
    }

    public static interface TransmitFavoriteCollection
    extends ObjCClass {
        public String name();

        public NSArray favorites();
    }
}

