/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.jna;

import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.serializer.Deserializer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;

public class PlistDeserializer
implements Deserializer<NSDictionary> {
    private static final Logger log = Logger.getLogger(PlistDeserializer.class);
    final NSDictionary dict;

    public PlistDeserializer(NSDictionary dict) {
        this.dict = dict;
    }

    public String stringForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    public boolean booleanForKey(String key) {
        String value = this.stringForKey(key);
        if (null == value) {
            return false;
        }
        return value.equalsIgnoreCase(String.valueOf(1));
    }

    public NSDictionary objectForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        if (value.isKindOfClass(Rococoa.createClass((String)"NSDictionary", NSDictionary._Class.class))) {
            return (NSDictionary)Rococoa.cast((ObjCObject)value, NSDictionary.class);
        }
        log.warn((Object)String.format("Unexpected value type for serialized key %s", key));
        return null;
    }

    public <T> List<T> listForKey(String key) {
        NSObject value = this.dict.objectForKey(key);
        if (null == value) {
            return null;
        }
        if (value.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class))) {
            NSObject next;
            NSArray array = (NSArray)Rococoa.cast((ObjCObject)value, NSArray.class);
            NSEnumerator enumerator = array.objectEnumerator();
            ArrayList<Object> list = new ArrayList<Object>();
            while ((next = enumerator.nextObject()) != null) {
                if (next.isKindOfClass(Rococoa.createClass((String)"NSDictionary", NSDictionary._Class.class))) {
                    list.add(Rococoa.cast((ObjCObject)next, NSDictionary.class));
                }
                if (!next.isKindOfClass(Rococoa.createClass((String)"NSString", NSString._Class.class))) continue;
                list.add(((NSString)Rococoa.cast((ObjCObject)next, NSString.class)).toString());
            }
            return list;
        }
        log.warn((Object)String.format("Unexpected value type for serialized key %s", key));
        return null;
    }
}

