/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.jna;

import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.serializer.Reader;
import org.apache.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;

public abstract class PlistReader<S extends Serializable>
implements Reader<S> {
    private static final Logger log = Logger.getLogger(PlistReader.class);

    public Collection<S> readCollection(Local file) throws AccessDeniedException {
        NSObject next;
        if (!file.exists()) {
            throw new LocalAccessDeniedException(file.getAbsolute());
        }
        Collection c = new Collection();
        NSArray list = NSArray.arrayWithContentsOfFile((String)file.getAbsolute());
        if (null == list) {
            log.error((Object)String.format("Invalid bookmark file %s", file));
            return c;
        }
        NSEnumerator i = list.objectEnumerator();
        while ((next = i.nextObject()) != null) {
            NSDictionary dict;
            S object;
            if (!next.isKindOfClass(Rococoa.createClass((String)"NSDictionary", NSDictionary._Class.class)) || null == (object = this.deserialize(dict = (NSDictionary)Rococoa.cast((ObjCObject)next, NSDictionary.class)))) continue;
            c.add(object);
        }
        return c;
    }

    public S read(Local file) throws AccessDeniedException {
        if (!file.exists()) {
            throw new LocalAccessDeniedException(file.getAbsolute());
        }
        if (!file.isFile()) {
            throw new LocalAccessDeniedException(file.getAbsolute());
        }
        NSDictionary dict = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == dict) {
            log.error((Object)String.format("Invalid bookmark file %s", file));
            return null;
        }
        return this.deserialize(dict);
    }

    public abstract S deserialize(NSDictionary var1);
}

