/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.io.IRODSFile;

public class IRODSAttributesFinderFeature
implements AttributesFinder {
    private final IRODSSession session;

    public IRODSAttributesFinderFeature(IRODSSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        try {
            IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
            IRODSFile f = fs.getIRODSFileFactory().instanceIRODSFile(file.getAbsolute());
            if (!f.exists()) {
                throw new NotfoundException(file.getAbsolute());
            }
            PathAttributes attributes = new PathAttributes();
            ObjStat stats = fs.getObjStat(f.getAbsolutePath());
            attributes.setModificationDate(stats.getModifiedAt().getTime());
            attributes.setCreationDate(stats.getCreatedAt().getTime());
            attributes.setSize(stats.getObjSize());
            attributes.setChecksum(Checksum.parse((String)Hex.encodeHexString((byte[])Base64.decodeBase64((String)stats.getChecksum()))));
            attributes.setOwner(stats.getOwnerName());
            attributes.setGroup(stats.getOwnerZone());
            return attributes;
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        return this;
    }
}

