/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.io.IRODSFile;

public class IRODSDeleteFeature
implements Delete {
    private final IRODSSession session;

    public IRODSDeleteFeature(IRODSSession session) {
        this.session = session;
    }

    public void delete(List<Path> files, LoginCallback prompt, Delete.Callback callback) throws BackgroundException {
        ArrayList<Path> deleted = new ArrayList<Path>();
        for (Path file : files) {
            boolean skip = false;
            for (Path d : deleted) {
                if (!file.isChild(d)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            deleted.add(file);
            callback.delete(file);
            try {
                IRODSFile f = ((IRODSFileSystemAO)this.session.getClient()).getIRODSFileFactory().instanceIRODSFile(file.getAbsolute());
                if (!f.exists()) {
                    throw new NotfoundException(String.format("%s doesn't exist", file.getAbsolute()));
                }
                if (f.isFile()) {
                    ((IRODSFileSystemAO)this.session.getClient()).fileDeleteForce(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                ((IRODSFileSystemAO)this.session.getClient()).directoryDeleteForce(f);
            }
            catch (JargonException e) {
                throw new IRODSExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        return true;
    }

    public boolean isRecursive() {
        return true;
    }
}

