/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.io.IRODSFile;

public class IRODSFindFeature
implements Find {
    private final IRODSSession session;
    private Cache<Path> cache;

    public IRODSFindFeature(IRODSSession session) {
        this.session = session;
        this.cache = PathCache.empty();
    }

    public boolean find(Path file) throws BackgroundException {
        AttributedList list;
        if (file.isRoot()) {
            return true;
        }
        if (this.cache.isCached((Referenceable)file.getParent())) {
            list = this.cache.get((Referenceable)file.getParent());
        } else {
            list = new AttributedList();
            this.cache.put((Referenceable)file.getParent(), list);
        }
        if (list.contains((Referenceable)file)) {
            return true;
        }
        if (this.cache.isHidden((Referenceable)file)) {
            return false;
        }
        try {
            IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
            IRODSFile f = fs.getIRODSFileFactory().instanceIRODSFile(file.getAbsolute());
            boolean found = fs.isFileExists(f);
            if (found) {
                list.add((Referenceable)file);
            } else {
                list.attributes().addHidden((Object)file);
            }
            return found;
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

