/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.protovalues.AuditActionEnum;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.domain.AuditedAction;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQueryOrderByField;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuditAOImpl
extends IRODSGenericAO {
    protected final transient IRODSGenQueryExecutor irodsGenQueryExecutor;
    public static final Logger log = LoggerFactory.getLogger(AbstractAuditAOImpl.class);

    public AbstractAuditAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.irodsGenQueryExecutor = this.getIRODSAccessObjectFactory().getIRODSGenQueryExecutor(irodsAccount);
    }

    protected AuditedAction getAuditedActionForFile(IRODSFile irodsFile, String auditActionCode, String timeStampInIRODSFormat) throws DataNotFoundException, JargonException {
        IRODSQueryResultSet resultSet;
        log.info("getAuditedActionForDataObject()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("null or empty irodsFile");
        }
        if (auditActionCode == null || auditActionCode.isEmpty()) {
            throw new IllegalArgumentException("null or empty auditActionCode");
        }
        if (timeStampInIRODSFormat == null || timeStampInIRODSFormat.isEmpty()) {
            throw new IllegalArgumentException("null or empty timeStampInIRODSFormat");
        }
        log.info("looking up data object id via objStat");
        CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
        ObjStat objStat = collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(irodsFile.getAbsolutePath());
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        String absPath = MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
        log.info("absPath for querying iCAT:{}", (Object)absPath);
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_OBJ_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_USER_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_ACTION_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_COMMENT).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_MODIFY_TIME).addConditionAsGenQueryField(RodsGenQueryEnum.COL_AUDIT_OBJ_ID, QueryConditionOperators.EQUAL, objStat.getDataId()).addConditionAsGenQueryField(RodsGenQueryEnum.COL_AUDIT_ACTION_ID, QueryConditionOperators.EQUAL, String.valueOf(auditActionCode)).addConditionAsGenQueryField(RodsGenQueryEnum.COL_AUDIT_CREATE_TIME, QueryConditionOperators.EQUAL, String.valueOf(timeStampInIRODSFormat)).addOrderByGenQueryField(RodsGenQueryEnum.COL_AUDIT_CREATE_TIME, GenQueryOrderByField.OrderByType.ASC);
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(1);
            String zone = MiscIRODSUtils.getZoneInPath(objStat.getAbsolutePath());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, 0, zone);
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
        return this.buildAuditedActionForResultRow(irodsFile, resultSet.getFirstResult());
    }

    protected List<AuditedAction> findAllAuditRecordsForFile(IRODSFile irodsFile, int partialStart, int numberOfResultsDesired) throws FileNotFoundException, JargonException {
        IRODSQueryResultSet resultSet;
        log.info("findAllAuditRecordsForFile()");
        if (irodsFile == null) {
            throw new IllegalArgumentException("null or empty irodsFile");
        }
        if (partialStart < 0) {
            throw new IllegalArgumentException("partial start must be >= 0");
        }
        if (numberOfResultsDesired < 1) {
            throw new IllegalArgumentException("numberOfResultsDesired must be >= 1");
        }
        log.info("looking up data object id via objStat");
        CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
        ObjStat objStat = collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(irodsFile.getAbsolutePath());
        log.info("irodsFile:{}", (Object)irodsFile);
        log.info("partialStart:{}", (Object)partialStart);
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        ArrayList<AuditedAction> auditedActions = new ArrayList<AuditedAction>();
        IRODSGenQueryBuilder builder = new IRODSGenQueryBuilder(true, null);
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_OBJ_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_USER_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_ACTION_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_COMMENT).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_AUDIT_MODIFY_TIME).addConditionAsGenQueryField(RodsGenQueryEnum.COL_AUDIT_OBJ_ID, QueryConditionOperators.EQUAL, objStat.getDataId());
            IRODSGenQueryFromBuilder irodsQuery = builder.exportIRODSQueryFromBuilder(numberOfResultsDesired);
            String zone = MiscIRODSUtils.getZoneInPath(objStat.getAbsolutePath());
            resultSet = this.irodsGenQueryExecutor.executeIRODSQueryAndCloseResultInZone(irodsQuery, partialStart, zone);
        }
        catch (GenQueryBuilderException e) {
            log.error("error building query", (Throwable)e);
            throw new JargonException("error building query", e);
        }
        catch (JargonQueryException jqe) {
            log.error("error executing query", (Throwable)jqe);
            throw new JargonException("error executing query", jqe);
        }
        for (IRODSQueryResultRow row : resultSet.getResults()) {
            AuditedAction auditedAction = this.buildAuditedActionForResultRow(irodsFile, row);
            auditedActions.add(auditedAction);
            log.info("added audited action:{}", (Object)auditedAction);
        }
        return auditedActions;
    }

    protected AuditedAction buildAuditedActionForResultRow(IRODSFile irodsFile, IRODSQueryResultRow row) throws NumberFormatException, JargonException {
        AuditedAction auditedAction = new AuditedAction();
        auditedAction.setObjectId(Integer.parseInt(row.getColumn(0)));
        auditedAction.setDomainObjectUniqueName(irodsFile.getAbsolutePath());
        auditedAction.setUserId(Integer.parseInt(row.getColumn(1)));
        auditedAction.setUserName(row.getColumn(2));
        auditedAction.setAuditActionEnum(AuditActionEnum.valueOf(Integer.parseInt(row.getColumn(3))));
        auditedAction.setComment(row.getColumn(4));
        auditedAction.setCreatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(5)));
        auditedAction.setTimeStampInIRODSFormat(row.getColumn(5));
        auditedAction.setUpdatedAt(IRODSDataConversionUtil.getDateFromIRODSValue(row.getColumn(6)));
        auditedAction.setLastResult(row.isLastResult());
        auditedAction.setCount(row.getRecordCount());
        auditedAction.setCount(row.getRecordCount());
        auditedAction.setLastResult(row.isLastResult());
        return auditedAction;
    }
}

