/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(SimpleHandler.class);
    private XMLReader xr = null;
    private StringBuffer textContent = null;
    protected SimpleHandler currentHandler = null;
    protected SimpleHandler parentHandler = null;

    public SimpleHandler(XMLReader xr) {
        this.xr = xr;
        this.textContent = new StringBuffer();
        this.currentHandler = this;
    }

    public void transferControlToHandler(SimpleHandler toHandler) {
        this.currentHandler = toHandler;
        toHandler.parentHandler = this;
        this.xr.setContentHandler(this.currentHandler);
        this.xr.setErrorHandler(this.currentHandler);
        log.debug((Object)("Transferred control to handler " + toHandler.getClass().getSimpleName()));
    }

    public void returnControlToParentHandler() {
        if (this.isChildHandler()) {
            this.parentHandler.currentHandler = this.parentHandler;
            this.parentHandler.controlReturned(this);
            this.currentHandler = this.parentHandler;
            this.xr.setContentHandler(this.currentHandler);
            this.xr.setErrorHandler(this.currentHandler);
            log.debug((Object)("Returned control from handler " + this.getClass().getSimpleName()));
        } else {
            log.debug((Object)("Ignoring call to return control to parent handler, as this class has no parent: " + this.getClass().getSimpleName()));
        }
    }

    public boolean isChildHandler() {
        return this.parentHandler != null;
    }

    public void controlReturned(SimpleHandler childHandler) {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        try {
            Method method = this.currentHandler.getClass().getMethod("start" + name, new Class[0]);
            method.invoke((Object)this.currentHandler, new Object[0]);
            log.debug((Object)("Processed " + this.getClass().getSimpleName() + " startElement method for '" + name + "'"));
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)("Skipped non-existent " + this.getClass().getSimpleName() + " startElement method for '" + name + "'"));
        }
        catch (Exception t) {
            log.error((Object)("Unable to invoke " + this.getClass().getSimpleName() + " startElement method for '" + name + "'"), (Throwable)t);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        String elementText = this.textContent.toString().trim();
        try {
            Method method = this.currentHandler.getClass().getMethod("end" + name, String.class);
            method.invoke((Object)this.currentHandler, elementText);
            log.debug((Object)("Processed " + this.getClass().getSimpleName() + " endElement method for '" + name + "'"));
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)("Skipped non-existent " + this.getClass().getSimpleName() + " endElement method for '" + name + "'"));
        }
        catch (Exception t) {
            log.error((Object)("Unable to invoke " + this.getClass().getSimpleName() + " endElement method for '" + name + "'"), (Throwable)t);
        }
        this.textContent = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.textContent.append(ch, start, length);
    }
}

