/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jets3t.service.model.StorageOwner;

public abstract class BaseStorageItem {
    public static final String METADATA_HEADER_CREATION_DATE = "Date";
    public static final String METADATA_HEADER_LAST_MODIFIED_DATE = "Last-Modified";
    public static final String METADATA_HEADER_DATE = "Date";
    public static final String METADATA_HEADER_CONTENT_MD5 = "Content-MD5";
    public static final String METADATA_HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String METADATA_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String METADATA_HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String METADATA_HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String METADATA_HEADER_CONTENT_LANGUAGE = "Content-Language";
    public static final String METADATA_HEADER_ETAG = "ETag";
    private String name = null;
    private StorageOwner owner = null;
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    protected BaseStorageItem(String name) {
        this.name = name;
    }

    protected BaseStorageItem() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getMetadataMap() {
        return Collections.unmodifiableMap(this.metadata);
    }

    protected Map<String, Object> lookupMetadataSubsetMap(String keyname) {
        HashMap map = (HashMap)this.metadata.get(keyname);
        if (map == null) {
            map = new HashMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<String, Object> getUserMetadataMap() {
        return this.lookupMetadataSubsetMap("__user__");
    }

    public Map<String, Object> getServiceMetadataMap() {
        return this.lookupMetadataSubsetMap("__service__");
    }

    public Map<String, Object> getHttpMetadataMap() {
        return this.lookupMetadataSubsetMap("__http__");
    }

    public Map<String, Object> getCompleteMetadataMap() {
        return this.lookupMetadataSubsetMap("__complete__");
    }

    protected boolean isMatchingMetadataName(String name1, String name2) {
        if (name1 == null && name2 == null) {
            return true;
        }
        if (name1 == null || name2 == null) {
            return false;
        }
        return name1.toLowerCase().equals(name2.toLowerCase());
    }

    protected Object getMetadataCaseInsensitiveFromMap(String name, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!this.isMatchingMetadataName(entry.getKey(), name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Object getMetadata(String name) {
        Object httpMetadataValue = this.getHttpMetadata(name);
        if (httpMetadataValue != null) {
            return httpMetadataValue;
        }
        return this.getMetadataCaseInsensitiveFromMap(name, this.metadata);
    }

    public boolean containsMetadata(String name) {
        for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
            if (!this.isMatchingMetadataName(entry.getKey(), name)) continue;
            return true;
        }
        return false;
    }

    public Object getServiceMetadata(String name) {
        return this.getMetadataCaseInsensitiveFromMap(name, this.getServiceMetadataMap());
    }

    public Object getUserMetadata(String name) {
        return this.getMetadataCaseInsensitiveFromMap(name, this.getUserMetadataMap());
    }

    public Object getHttpMetadata(String name) {
        return this.getMetadataCaseInsensitiveFromMap(name, this.getHttpMetadataMap());
    }

    protected void addMetadata(String name, Object value) {
        this.removeMetadata(name);
        this.metadata.put(name, value);
    }

    public void addMetadata(String name, String value) {
        this.addMetadata(name, (Object)value);
    }

    public void addMetadata(String name, Date value) {
        this.addMetadata(name, (Object)value);
    }

    public void addMetadata(String name, StorageOwner value) {
        this.addMetadata(name, (Object)value);
    }

    public void addAllMetadata(Map<String, Object> metadataToAdd) {
        for (Map.Entry<String, Object> entry : metadataToAdd.entrySet()) {
            this.addMetadata(entry.getKey(), entry.getValue());
        }
    }

    public void removeMetadata(String name) {
        String existingItemKey = null;
        for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
            if (!this.isMatchingMetadataName(entry.getKey(), name)) continue;
            existingItemKey = entry.getKey();
        }
        if (existingItemKey != null || name == null) {
            this.metadata.remove(existingItemKey);
        }
    }

    public void replaceAllMetadata(Map<String, Object> metadata) {
        this.metadata.clear();
        this.addAllMetadata(metadata);
    }

    public StorageOwner getOwner() {
        return this.owner;
    }

    public void setOwner(StorageOwner owner) {
        this.owner = owner;
    }
}

