/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import com.jamesmurty.utils.XMLBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jets3t.service.utils.ServiceUtils;

public class LifecycleConfig {
    public static final String STORAGE_CLASS_GLACIER = "GLACIER";
    private List<Rule> rules = new ArrayList<Rule>();

    public LifecycleConfig(List<Rule> rules) {
        this.rules = rules;
    }

    public LifecycleConfig() {
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public Rule newRule(String id, String prefix, Boolean enabled) {
        Rule rule = new Rule(id, prefix, enabled);
        this.rules.add(rule);
        return rule;
    }

    public String toXml() throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder builder = XMLBuilder.create((String)"LifecycleConfiguration");
        for (Rule rule : this.getRules()) {
            XMLBuilder b = builder.elem("Rule");
            if (rule.id != null && rule.id.length() > 0) {
                b.elem("ID").t(rule.id);
            }
            b.elem("Prefix").t(rule.prefix).up().elem("Status").t(rule.enabled != false ? "Enabled" : "Disabled").up();
            if (rule.transition != null) {
                XMLBuilder tBuilder = b.elem("Transition");
                if (rule.transition.date != null) {
                    tBuilder.elem("Date").t(ServiceUtils.formatIso8601Date(rule.transition.date));
                }
                if (rule.transition.days != null) {
                    tBuilder.elem("Days").t(Integer.toString(rule.transition.days));
                }
                tBuilder.elem("StorageClass").t(rule.transition.storageClass);
            }
            if (rule.expiration == null) continue;
            XMLBuilder eBuilder = b.elem("Expiration");
            if (rule.expiration.date != null) {
                eBuilder.elem("Date").t(ServiceUtils.formatIso8601Date(rule.expiration.date));
            }
            if (rule.expiration.days == null) continue;
            eBuilder.elem("Days").t(Integer.toString(rule.expiration.days));
        }
        return builder.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LifecycleConfig that = (LifecycleConfig)o;
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public int hashCode() {
        return this.rules != null ? this.rules.hashCode() : 0;
    }

    public class Rule {
        protected String id;
        protected String prefix;
        protected Boolean enabled;
        protected Transition transition;
        protected Expiration expiration;

        public Rule() {
        }

        public Rule(String id, String prefix, Boolean enabled) {
            this.id = id;
            this.prefix = prefix;
            this.enabled = enabled;
        }

        public Expiration newExpiration() {
            this.expiration = new Expiration();
            return this.expiration;
        }

        public Transition newTransition() {
            this.transition = new Transition();
            return this.transition;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Transition getTransition() {
            return this.transition;
        }

        public void setTransition(Transition transition) {
            this.transition = transition;
        }

        public Expiration getExpiration() {
            return this.expiration;
        }

        public void setExpiration(Expiration expiration) {
            this.expiration = expiration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            if (this.expiration != null ? !this.expiration.equals(rule.expiration) : rule.expiration != null) {
                return false;
            }
            return !(this.transition != null ? !this.transition.equals(rule.transition) : rule.transition != null);
        }

        public int hashCode() {
            int result = this.transition != null ? this.transition.hashCode() : 0;
            result = 31 * result + (this.expiration != null ? this.expiration.hashCode() : 0);
            return result;
        }
    }

    public class Transition
    extends TimeEvent {
        protected String storageClass;

        public Transition() {
            this.storageClass = LifecycleConfig.STORAGE_CLASS_GLACIER;
        }

        public Transition(Date date, String storageClass) {
            super(date);
            this.storageClass = LifecycleConfig.STORAGE_CLASS_GLACIER;
            this.storageClass = storageClass;
        }

        public Transition(Integer days, String storageClass) {
            super(days);
            this.storageClass = LifecycleConfig.STORAGE_CLASS_GLACIER;
            this.storageClass = storageClass;
        }

        public String getStorageClass() {
            return this.storageClass;
        }

        public void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }
    }

    public class Expiration
    extends TimeEvent {
        public Expiration() {
        }

        public Expiration(Date date) {
            super(date);
        }

        public Expiration(Integer days) {
            super(days);
        }
    }

    public abstract class TimeEvent {
        protected Integer days;
        protected Date date;

        public TimeEvent() {
        }

        public TimeEvent(Integer days) {
            this.days = days;
        }

        public TimeEvent(Date date) {
            this.date = date;
        }

        public Integer getDays() {
            return this.days;
        }

        public void setDays(Integer days) {
            this.days = days;
            this.date = null;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
            this.days = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TimeEvent)) {
                return false;
            }
            TimeEvent timeEvent = (TimeEvent)o;
            if (this.date != null ? !this.date.equals(timeEvent.date) : timeEvent.date != null) {
                return false;
            }
            return !(this.days != null ? !this.days.equals(timeEvent.days) : timeEvent.days != null);
        }

        public int hashCode() {
            int result = this.days != null ? this.days.hashCode() : 0;
            result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
            return result;
        }
    }
}

