/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.jets3t.service.impl.rest.httpclient.RepeatableRequestEntity;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

public class SignatureUtils {
    protected static final SimpleDateFormat awsFlavouredISO8601DateParser = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAwsFlavouredISO8601Date(Date date) {
        SimpleDateFormat simpleDateFormat = awsFlavouredISO8601DateParser;
        synchronized (simpleDateFormat) {
            return awsFlavouredISO8601DateParser.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseAwsFlavouredISO8601Date(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = awsFlavouredISO8601DateParser;
        synchronized (simpleDateFormat) {
            return awsFlavouredISO8601DateParser.parse(dateString);
        }
    }

    public static String awsRegionForRequest(URI requestURI) {
        String host = requestURI.getHost().toLowerCase();
        if (host.endsWith("s3.amazonaws.com") || host.endsWith("s3-accelerate.amazonaws.com") || host.endsWith("s3-accelerate.dualstack.amazonaws.com") || host.endsWith("s3-external-1.amazonaws.com")) {
            return null;
        }
        if (host.endsWith(".amazonaws.com") || host.contains(".amazonaws.com.")) {
            String[] hostSplit = host.split("\\.");
            String regionNameCandidate = null;
            boolean wasS3PrefixFound = false;
            for (String portion : hostSplit) {
                if (portion.equals("amazonaws")) break;
                if (portion.equals("s3")) {
                    wasS3PrefixFound = true;
                }
                regionNameCandidate = portion;
            }
            if (null == regionNameCandidate) {
                return null;
            }
            if (regionNameCandidate.startsWith("s3-")) {
                return regionNameCandidate.substring("s3-".length());
            }
            if (wasS3PrefixFound) {
                return regionNameCandidate;
            }
        }
        return null;
    }

    public static void awsV4SignRequestAuthorizationHeader(String requestSignatureVersion, HttpUriRequest httpMethod, ProviderCredentials providerCredentials, String requestPayloadHexSha256Hash, String region) {
        if (httpMethod.getFirstHeader("Host") == null) {
            httpMethod.setHeader("Host", httpMethod.getURI().getHost());
        }
        String timestampISO8601 = SignatureUtils.awsV4ParseAndFormatDate(httpMethod);
        if (httpMethod.getFirstHeader("x-amz-date") == null) {
            httpMethod.setHeader("x-amz-date", timestampISO8601);
        }
        String canonicalRequestString = SignatureUtils.awsV4BuildCanonicalRequestString(httpMethod, requestPayloadHexSha256Hash, region);
        String stringToSign = SignatureUtils.awsV4BuildStringToSign(requestSignatureVersion, canonicalRequestString, timestampISO8601, region);
        byte[] signingKey = SignatureUtils.awsV4BuildSigningKey(providerCredentials.getSecretKey(), timestampISO8601, region);
        String signature = ServiceUtils.toHex(ServiceUtils.hmacSHA256(signingKey, ServiceUtils.stringToBytes(stringToSign)));
        String authorizationHeaderValue = SignatureUtils.awsV4BuildAuthorizationHeaderValue(providerCredentials.getAccessKey(), signature, requestSignatureVersion, canonicalRequestString, timestampISO8601, region);
        httpMethod.setHeader("Authorization", authorizationHeaderValue);
    }

    public static String awsV4GetOrCalculatePayloadHash(HttpUriRequest httpMethod) {
        String requestPayloadHexSHA256Hash = null;
        Header sha256Header = httpMethod.getFirstHeader("x-amz-content-sha256");
        if (sha256Header != null) {
            return sha256Header.getValue();
        }
        if (httpMethod instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)httpMethod).getEntity();
            if (entity instanceof StringEntity || entity instanceof ByteArrayEntity || entity instanceof RepeatableRequestEntity) {
                try {
                    InputStream requestIS = entity.getContent();
                    while (requestIS instanceof ProgressMonitoredInputStream) {
                        requestIS = ((ProgressMonitoredInputStream)requestIS).getWrappedInputStream();
                    }
                    requestPayloadHexSHA256Hash = ServiceUtils.toHex(ServiceUtils.hashSHA256(requestIS, true));
                    requestIS.reset();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to automatically set required header \"x-amz-content-sha256\" for request with entity " + entity, e);
                }
            } else if (entity != null) {
                throw new RuntimeException("Header \"x-amz-content-sha256\" set to the hex-encoded SHA256 hash of the request payload is required for AWS Version 4 request signing, please set this on: " + httpMethod);
            }
        }
        if (requestPayloadHexSHA256Hash == null) {
            requestPayloadHexSHA256Hash = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
        }
        return requestPayloadHexSHA256Hash;
    }

    public static String awsV4ParseAndFormatDate(HttpUriRequest httpMethod) {
        Header dateHeader = httpMethod.getFirstHeader("x-amz-date");
        if (dateHeader == null) {
            dateHeader = httpMethod.getFirstHeader("Date");
        }
        if (dateHeader == null) {
            throw new RuntimeException("Request must have a date timestamp applied before it can be signed with AWS Version 4, but no date value found in \"x-amz-date\" or \"Date\" headers");
        }
        String dateValue = dateHeader.getValue();
        if (dateValue.endsWith("Z")) {
            try {
                SignatureUtils.parseAwsFlavouredISO8601Date(dateValue);
                return dateValue;
            }
            catch (ParseException e) {
                try {
                    Date date = ServiceUtils.parseIso8601Date(dateValue);
                    return SignatureUtils.formatAwsFlavouredISO8601Date(date);
                }
                catch (ParseException e2) {
                    throw new RuntimeException("Invalid date value in request: " + dateValue, e2);
                }
            }
        }
        try {
            Date date = ServiceUtils.parseRfc822Date(dateValue);
            return SignatureUtils.formatAwsFlavouredISO8601Date(date);
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date value in request: " + dateValue, e);
        }
    }

    public static String awsV4BuildCanonicalRequestString(HttpUriRequest httpMethod, String requestPayloadHexSha256Hash, String region) {
        Header[] headers;
        URI uri = httpMethod.getURI();
        String httpRequestMethod = httpMethod.getMethod();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (Header header : headers = httpMethod.getAllHeaders()) {
            String name = header.getName().trim().toLowerCase();
            String value = header.getValue().trim();
            headersMap.put(name, value);
        }
        return SignatureUtils.awsV4BuildCanonicalRequestString(uri, httpRequestMethod, headersMap, requestPayloadHexSha256Hash);
    }

    public static String awsV4BuildCanonicalRequestString(URI uri, String httpMethod, Map<String, String> headersMap, String requestPayloadHexSha256Hash) {
        StringBuilder canonicalStringBuf = new StringBuilder();
        canonicalStringBuf.append(httpMethod).append("\n");
        String absolutePath = uri.getPath();
        if (absolutePath.length() == 0) {
            canonicalStringBuf.append("/");
        } else {
            canonicalStringBuf.append(SignatureUtils.awsV4EncodeURI(absolutePath, false));
        }
        canonicalStringBuf.append("\n");
        String query = uri.getRawQuery();
        if (query == null || query.length() == 0) {
            canonicalStringBuf.append("\n");
        } else {
            TreeMap<String, String> sortedQueryParameters = new TreeMap<String, String>();
            for (String paramPair : query.split("&")) {
                String[] paramNameValue = paramPair.split("=", 2);
                String name = paramNameValue[0];
                String value = "";
                if (paramNameValue.length > 1) {
                    value = paramNameValue[1];
                }
                sortedQueryParameters.put(name, value.replace("/", "%2F"));
            }
            boolean isPriorParam = false;
            for (Map.Entry entry : sortedQueryParameters.entrySet()) {
                if (isPriorParam) {
                    canonicalStringBuf.append("&");
                }
                canonicalStringBuf.append((String)entry.getKey()).append("=").append((String)entry.getValue());
                isPriorParam = true;
            }
            canonicalStringBuf.append("\n");
        }
        TreeMap<String, String> sortedHeaders = new TreeMap<String, String>();
        sortedHeaders.putAll(headersMap);
        for (Map.Entry entry : sortedHeaders.entrySet()) {
            canonicalStringBuf.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
        }
        canonicalStringBuf.append("\n");
        boolean isPriorSignedHeader = false;
        for (Map.Entry entry : sortedHeaders.entrySet()) {
            if (isPriorSignedHeader) {
                canonicalStringBuf.append(";");
            }
            canonicalStringBuf.append((String)entry.getKey());
            isPriorSignedHeader = true;
        }
        canonicalStringBuf.append("\n");
        canonicalStringBuf.append(requestPayloadHexSha256Hash);
        return canonicalStringBuf.toString();
    }

    public static String awsV4BuildStringToSign(String requestSignatureVersion, String canonicalRequestString, String timestampISO8601, String region) {
        String service = "s3";
        String datestampISO8601 = timestampISO8601.substring(0, 8);
        String credentialScope = datestampISO8601 + "/" + region + "/" + service + "/aws4_request";
        String hashedCanonicalString = ServiceUtils.toHex(ServiceUtils.hash(canonicalRequestString, "SHA-256"));
        return requestSignatureVersion + "\n" + timestampISO8601 + "\n" + credentialScope + "\n" + hashedCanonicalString;
    }

    public static byte[] awsV4BuildSigningKey(String secretAccessKey, String timestampISO8601, String region) {
        String service = "s3";
        String datestampISO8601 = timestampISO8601.substring(0, 8);
        byte[] kDate = ServiceUtils.hmacSHA256("AWS4" + secretAccessKey, datestampISO8601);
        byte[] kRegion = ServiceUtils.hmacSHA256(kDate, ServiceUtils.stringToBytes(region));
        byte[] kService = ServiceUtils.hmacSHA256(kRegion, ServiceUtils.stringToBytes(service));
        byte[] kSigning = ServiceUtils.hmacSHA256(kService, ServiceUtils.stringToBytes("aws4_request"));
        return kSigning;
    }

    public static String awsV4BuildAuthorizationHeaderValue(String accessKey, String requestSignature, String requestSignatureVersion, String canonicalRequestString, String timestampISO8601, String region) {
        String service = "s3";
        String datestampISO8601 = timestampISO8601.substring(0, 8);
        String[] canonicalStringComponents = canonicalRequestString.split("\n");
        String signedHeaders = canonicalStringComponents[canonicalStringComponents.length - 2];
        String credentialScope = datestampISO8601 + "/" + region + "/" + service + "/aws4_request";
        return requestSignatureVersion + " Credential=" + accessKey + "/" + credentialScope + ",SignedHeaders=" + signedHeaders + ",Signature=" + requestSignature;
    }

    public static URI awsV4CorrectHostnameForRegion(URI uri, String region) {
        String hostname = uri.getHost();
        hostname = hostname.replace("s3-accelerate.dualstack", "s3");
        hostname = hostname.replace("s3-accelerate", "s3");
        Object[] hostSplit = hostname.split("\\.");
        hostSplit[hostSplit.length - 3] = region.equals("us-east-1") ? "s3" : "s3-" + region;
        String newHost = ServiceUtils.join(hostSplit, ".");
        try {
            String rawPathAndQuery = uri.getRawPath();
            if (uri.getRawQuery() != null) {
                rawPathAndQuery = rawPathAndQuery + "?" + uri.getRawQuery();
            }
            return new URL(uri.getScheme(), newHost, uri.getPort(), rawPathAndQuery).toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String awsV4EncodeURI(CharSequence input, boolean encodeSlash) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == '~' || ch == '.') {
                result.append(ch);
                continue;
            }
            if (ch == '/') {
                result.append(encodeSlash ? "%2F" : Character.valueOf(ch));
                continue;
            }
            String hex = RestUtils.encodeUrlString(String.valueOf(ch));
            result.append(hex);
        }
        return result.toString();
    }

    static {
        awsFlavouredISO8601DateParser.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }
}

