/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.nio.LocalAttributesFinderFeature;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.EnumSet;
import org.apache.log4j.Logger;

public class LocalListService
implements ListService {
    private static final Logger log = Logger.getLogger(LocalListService.class);
    private final LocalSession session;
    private final LocalAttributesFinderFeature feature;

    public LocalListService(LocalSession session) {
        this.session = session;
        this.feature = new LocalAttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList paths = new AttributedList();
        try (DirectoryStream<java.nio.file.Path> directoryStream = Files.newDirectoryStream(((FileSystem)this.session.getClient()).getPath(directory.getAbsolute(), new String[0]));){
            for (java.nio.file.Path path : directoryStream) {
                Path file;
                PathAttributes attributes = this.feature.convert(path);
                EnumSet<AbstractPath.Type> type = EnumSet.noneOf(AbstractPath.Type.class);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    type.add(AbstractPath.Type.directory);
                }
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    type.add(AbstractPath.Type.file);
                }
                if (Files.isSymbolicLink(path)) {
                    type.add(AbstractPath.Type.symboliclink);
                }
                if (!this.post(path, file = new Path(directory, path.getFileName().toString(), type, attributes))) continue;
                paths.add((Referenceable)file);
                listener.chunk(directory, paths);
            }
        }
        catch (IOException ex) {
            throw new LocalExceptionMappingService().map("Listing directory {0} failed", ex, directory);
        }
        return paths;
    }

    protected boolean post(java.nio.file.Path path, Path file) {
        if (Files.isSymbolicLink(path)) {
            try {
                Path target = new Path(path.toRealPath(new LinkOption[0]).toString(), EnumSet.of(AbstractPath.Type.file));
                AbstractPath.Type type = Files.isDirectory(path.toRealPath(new LinkOption[0]), new LinkOption[0]) ? AbstractPath.Type.directory : AbstractPath.Type.file;
                file.setType(EnumSet.of(AbstractPath.Type.symboliclink, type));
                target.setType(EnumSet.of(type));
                file.setSymlinkTarget(target);
            }
            catch (IOException e) {
                log.warn((Object)String.format("Failure to read symbolic link of %s. %s", file, e.getMessage()));
                return false;
            }
        }
        return true;
    }
}

