/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.nio.LocalDeleteFeature;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.util.Collections;

public class LocalMoveFeature
implements Move {
    private final LocalSession session;
    private Delete delete;

    public LocalMoveFeature(LocalSession session) {
        this.session = session;
        this.delete = new LocalDeleteFeature(session);
    }

    public void move(Path file, Path renamed, boolean exists, Delete.Callback callback) throws BackgroundException {
        try {
            if (exists) {
                this.delete.delete(Collections.singletonList(renamed), (LoginCallback)new DisabledLoginCallback(), callback);
            }
            Files.move(((FileSystem)this.session.getClient()).getPath(file.getAbsolute(), new String[0]), ((FileSystem)this.session.getClient()).getPath(renamed.getAbsolute(), new String[0]), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }

    public Move withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }
}

