/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystem;
import java.nio.file.StandardOpenOption;

public class LocalReadFeature
implements Read {
    private final LocalSession session;

    public LocalReadFeature(LocalSession session) {
        this.session = session;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            FileChannel channel = FileChannel.open(((FileSystem)this.session.getClient()).getPath(file.getAbsolute(), new String[0]), StandardOpenOption.READ);
            channel.position(status.getOffset());
            return Channels.newInputStream(channel);
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Download {0} failed", e, file);
        }
    }

    public boolean offset(Path file) throws BackgroundException {
        return true;
    }
}

